<%@ tag import="org.apache.commons.beanutils.DynaProperty"%>
<%@ tag import="org.apache.commons.lang.WordUtils"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="stripes" uri="http://stripes.sourceforge.net/stripes.tld"%>
<%@ taglib prefix="d" uri="http://displaytag.sf.net" %>
<%@ tag body-content="empty" %>

<%@ attribute name="groupId"        required="true"  type="java.lang.Long" rtexprvalue="true" %>
<%@ attribute name="projectId"      required="true"  type="java.lang.Long" rtexprvalue="true" %>
<%@ attribute name="experimentId"   required="false" type="java.lang.Long" rtexprvalue="true" %>
<%@ attribute name="userId"         required="true"  type="java.lang.Long" rtexprvalue="true" %>
<%@ attribute name="editingAllowed" required="false" type="java.lang.Boolean" rtexprvalue="true" %>
<%@ attribute name="domains" 		required="true"  type="edu.mit.broad.core.customreports.ReportDomain[]" rtexprvalue="true" %>
<%@ attribute name="fullName"       required="false" type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="view" 			required="false" type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="roles" 			required="false" type="java.util.List" rtexprvalue="true" %>
<%@ attribute name="categories"		required="false" type="java.util.List" rtexprvalue="true" %>
<%@ attribute name="assignableRoles" required="false" type="java.util.List" rtexprvalue="true" %>

<stripes:useActionBean var="bean" beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean"/>

<c:set var="_custom_reports.group_id"       scope="session" value="${groupId}"/>
<c:set var="_custom_reports.project_id"     scope="session" value="${projectId}"/>
<c:set var="_custom_reports.experiment_id"  scope="session" value="${experimentId}"/>
<c:set var="_custom_reports.user_id"        scope="session" value="${userId}"/>
<c:set var="_custom_reports.domains"        scope="session" value="${domains}"/>
<c:set var="_custom_reports.roles"          scope="session" value="${roles}"/>
<c:set var="_custom_reports.categories"     scope="session" value="${categories}"/>
<c:set var="_custom_reports.fullName"       scope="session" value="${fullName}"/>
<c:set var="_custom_reports.assignableRoles" scope="session" value="${assignableRoles}"/>

<c:choose>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders the list of custom reports to select.    --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${bean.view == 'reportList' || bean.view == null}">
        <div class="customreport-pagetitle">Custom Report Selection</div>
    	<p>
		<ul>
		<li>Select the radio button next to the report name
			and then hit the <em>View</em> or <em>Download</em> button.</li>
		<li>Please use the <em>Download</em> button to get large reports.</li>
		</ul>
		</p>

        <stripes:errors/>
        <stripes:form beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean">
            <table border="0">
                <tr>
                    <td colspan="2">
                        <d:table id="report" class="customreport" name="${bean.reports}">
                            <d:column>
                                <stripes:radio name="report.reportId" value="${report.reportId}"/>
                            </d:column>
                            <c:if test="${bean.domainsSize > 1}">
                                <d:column property="domain.description" title="Domain"/>
                            </c:if>
                            <d:column style="width: 200;" property="name" title="Name"/>
                            <d:column style="width: 150;" property="categoryList" title="Categories"/>
                            <d:column style="width: 150;" property="roleList" title="Roles"/>
                            <d:column style="text-align: left;" property="description" title="Description"/>

                            <c:if test="${editingAllowed}">
                                <d:column style="width: 80;" property="createdDateString" title="Created"/>
                                <d:column style="width: 110;" property="createdBy" title="Created By"/>
                                <d:column property="runCount" title="Run Count"/>
                                <d:column style="width: 80;" property="lastRunDateString" title="Last Run"/>
                                <d:column style="width: 110;" property="lastRunBy" title="Last Run By"/>
                            </c:if>
                        </d:table>
                    </td>
                </tr>
                <tr>
                    <td id="customreport-editbuttons">
                        <br />
                        <c:if test="${editingAllowed}">
                            <stripes:submit name="createReport" value="New"/>
                            <stripes:submit name="editReport" value="Edit"/>
                            <stripes:submit name="exportReport" value="Export"/>
                            <stripes:submit name="deleteReport" value="Delete"/>
                            <stripes:submit name="copyReport" value="Duplicate"/>
                        </c:if>
                    </td>
                    <td id="customreport-runbuttons">
                        <BR>
                        <stripes:hidden id="directDownloadFormat" name="directDownloadFormat" value=""/>
                        <stripes:submit name="resolveParameters" value="View"
                                        onclick="this.form.directDownloadFormat.value=''; return true;"/>
                        <stripes:submit name="resolveParameters" value="Download CSV"
                                        onclick="this.form.directDownloadFormat.value='csv'; return true;"/>
                        <stripes:submit name="resolveParameters" value="Download Excel"
                                    onclick="this.form.directDownloadFormat.value='xls'; return true;"/>
                    </td>
                </tr>
            </table>
        </stripes:form>
    </c:when>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders the parameter resolution screen.         --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${bean.view == 'resolveParameters'}">
        <div class="customreport-pagetitle">${bean.report.name}</div>

        <div class="customreport-subtitle">Please enter the following parameters:</div>

        <stripes:errors/>
        <stripes:form beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean">
            <table border="0">
                <tr>
                    <td>
                        <table class="customreport-summary">
                            <c:forEach items="${bean.report.parameters}" var="repparam">
                                <tr>
                                    <th>${repparam.prompt}</th>
                                    <td><stripes:textarea name="variables['${repparam.name}']"
                                            style="height: 1.8em; width: 250px;"/></td>
                                </tr>
                            </c:forEach>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <stripes:hidden name="report.reportId" value="${report.reportId}"/>
                        <stripes:hidden name="directDownloadFormat" value="${directDownloadFormat}" />
                        <stripes:submit name="executeReport" value="Run Report"/>
                    </td>
                </tr>
            </table>
        </stripes:form>
    </c:when>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders the report editing screen.               --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${bean.view == 'editReport'}">
    <script type="text/javascript">
        function insertParamRow() {
            var t=document.getElementById('paramsTable');
            var r=t.insertRow(-1);
            // parameter index, skipping headers row
            var idx = r.rowIndex-1;

            var y=r.insertCell(0);
            y.innerHTML="<input type=\"button\" onclick=\"deleteParamRow(this.parentNode.parentNode.rowIndex)\" value=\"Delete\"/>";

            var y=r.insertCell(1);
            y.innerHTML="<input type=\"text\" size=\"20\" name=\"report.parameters["+idx+"].name\"/>";
            var y=r.insertCell(2);
            y.innerHTML="<input type=\"text\" size=\"60\" name=\"report.parameters["+idx+"].prompt\"/>";
            var y=r.insertCell(3);
            y.innerHTML="<input type=\"text\" size=\"30\" name=\"report.parameters["+idx+"].typeClass\"/>";

            // reIndexParams();
        }
        function deleteParamRow(i) {
            var t=document.getElementById('paramsTable');
            var lastIndex = t.rows.length-1;
            t.deleteRow(i);
            if (i < lastIndex) {
                //alert("reindexing");
                // reIndexParams();
            }
        }
        function reIndexParams() {
            var t=document.getElementById('paramsTable');
            // go through each row, except header row
            // and reindex all parameters
            for (var i=1; i<t.rows.length; i++) {
                var r = t.rows[i];
                var regEx = new RegExp("parameters\\[\\d+\\]\\.", "gi");
                r.innerHTML = r.innerHTML.replace(regEx,"parameters["+(i-1)+"].");
            }
        }
        function deleleLastParamRow() {
            var t=document.getElementById('paramsTable');
            // skipping headers row
            if (t.rows.length <= 1)
                return;
            t.deleteRow(-1);
        }
    </script>
        <div class="customreport-pagetitle">Edit Custom Report</div>
		<ul>
		<li>Put a space before your colon and parameter name </li>
		<li>Select the proper data source name from the dropdown</li>
		</ul>
        <stripes:errors/>
        <stripes:form beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean">
            <table border="0">
                <tr>
                    <td>
                        <table class="customreport-summary">
                            <input type="hidden" name="report.reportId" value="${bean.report.reportId}"/>
                            <stripes:hidden name="report.lastRunDate" value="${bean.report.lastRunDate}"/>
                            <stripes:hidden name="report.lastRunBy" value="${bean.report.lastRunBy}"/>
                            <stripes:hidden name="report.runCount" value="${bean.report.runCount}"/>	
                            <stripes:hidden name="report.createdBy" value="${bean.report.createdBy}"/>	
                            <stripes:hidden name="report.createdDate" value="${bean.report.createdDate}"/>	                                                        
                         						
                            <tr>
                                <th>Name:</th>
                                <td><stripes:text size="80" name="report.name"/></td>
                            </tr>
                            <tr>
                                <th>Description:</th>
                                <td><stripes:text size="80" name="report.description"/></td>
                            </tr>
                            <tr>
                                <th>Domain:</th>
                                <td>
                                    <stripes:select name="report.domain">
                                        <stripes:options-collection collection="${bean.domains}" value="name" label="description"/>
                                    </stripes:select>
                                </td>
                            </tr>
                            <tr>
                                <th>Categories:</th>
                                <td>
                                    <stripes:textarea cols="80" rows="2" name="categoryList"/>
                                </td>
                            </tr>
                            <tr>
                                <th>Roles:</th>
                                <td>
                                    <c:choose>
                                        <c:when test="${empty assignableRoles}">
                                            <stripes:textarea cols="80" rows="2" name="roleList"/>
                                        </c:when>
                                        <c:otherwise>
                                            <c:forEach items="unavailableRoleList" var="i">
                                                <stripes:hidden name="roleList" value="i"/>
                                            </c:forEach>

                                            <stripes:select name="selectedRoleList" multiple="true" size="5">
                                                <stripes:options-collection collection="${bean.assignableRoles}"/>
                                            </stripes:select>
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </tr>
                            <tr>
                                <th>Data Source Name:</th>
                                <td>
                                    <stripes:select name="report.dataSourceName" id="speciesId">
					                <stripes:options-collection collection="${bean.dataSources}" />
						            </stripes:select>
                                </td>
                            </tr>
                            <tr>
                                <th>Restrict Access To:</th>
                                <td>
                                    <stripes:checkbox name="groupOnly" id="groupOnly"/>
                                    <stripes:label for="groupOnly">Group</stripes:label>
                                    <stripes:checkbox name="projectOnly" id="projectOnly"/>
                                    <stripes:label for="projectOnly">Project</stripes:label>
                                    <stripes:checkbox name="experimentOnly" id="experimentOnly"/>
                                    <stripes:label for="experimentOnly">Experiment</stripes:label>
                                </td>
                            </tr>
                            <tr>
                                <th>SQL:</th>
                                <td>
                                    <stripes:textarea cols="80" rows="30" name="report.data"/>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br />

                        <div class="customreport-pagetitle">Report Parameters</div>

                        <table id="paramsTable">
                            <tr>
                                <th width="20" align="center"><img src="${pageContext.request.contextPath}/images/trash.png" title="Selected rows will be deleted on save"/></th>
                                <th>Name</th>
                                <th>Prompt</th>
                                <th>Type Class</th>
                            </tr>

                            <c:set var="newIndex" value="${0}" scope="page"/>
                            <c:forEach items="${actionBean.report.parameters}" var="report" varStatus="loop">
                                <tr>
                                    <td width="20">
                                    <%--
                                        <div style="width:20px;">
                                            <stripes:checkbox name="deleteParameterIds" value="${report.parameterId}"
                                                              onclick="handleCheckboxRangeSelection(this, event);"/>
                                        </div>
                                    --%>
                                    	<input type="button" onclick="deleteParamRow(this.parentNode.parentNode.rowIndex)" value="Delete"/>
                                    </td>
                                    <td><stripes:hidden name="report.parameters[${loop.index}].parameterId"/>
                                        <%-- stripes:hidden name="report.parameters[${loop.index}].reportId"/ --%>
                                        <stripes:hidden name="report.parameters[${loop.index}].idx"/>
                                        <stripes:text size="20" name="report.parameters[${loop.index}].name"/></td>
                                    <td><stripes:text size="60" name="report.parameters[${loop.index}].prompt"/></td>
                                    <td><stripes:text size="30" name="report.parameters[${loop.index}].typeClass"/></td>
                                </tr>

                                <c:set var="newIndex" value="${loop.index + 1}" scope="page"/>
                            </c:forEach>

                        <!-- and one new row -->
                            <tr>
                                <td><input type="button" onclick="deleteParamRow(this.parentNode.parentNode.rowIndex)" value="Delete"/></td>
                                <td>
                                    <stripes:text size="20" name="report.parameters[${newIndex}].name"/></td>
                                <td><stripes:text size="60" name="report.parameters[${newIndex}].prompt"/></td>
                                <td><stripes:text size="30" name="report.parameters[${newIndex}].typeClass"/></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="center">
   						<input type="button" onclick="insertParamRow()" value="Add another row"/>
						<%-- input type="button" onclick="deleleLastParamRow()" value="Remove last row"/ --%>

                    </td>
                </tr>
                <tr>
                    <td align="left">
                        <br />
                        <stripes:submit name="saveReport" value="Save"/>
                        <stripes:submit name="validateReport" value="Validate"/>
                        <input type="button" value="Cancel" onClick="history.go(-1)" />
                    </td>
                </tr>
            </table>
        </stripes:form>
        <br/>
    	<p>
            Or upload an existing report definition from a template XML file
        </p>
        <stripes:form beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean">
            <table border="0">
                <tr>
                    <td>
                        <table class="customreport-summary">
                            <tr><th>Report XML Template:</th><td><stripes:file name="importedReport"/>&nbsp;<stripes:submit name="importReport" value="Import"/></td></tr>
                        </table>
                    </td>
                </tr>
            </table>
        </stripes:form>
    </c:when>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders the output of a report.                  --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${bean.view == 'viewReport'}">
        <div class="customreport-pagetitle">${bean.report.name}</div>
        <script type="text/javascript">var rownum=1;</script>
        <% // This set of if statements is to fix a bug with downloading & sorting where there were multiple stripes events occuring  %>
        <c:if test="${not empty bean.variables}">
            <stripes:url var="uri" beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean" event="executeReport"/>
        </c:if>
        <c:if test="${empty bean.variables}">
            <stripes:url var="uri" beanclass="edu.mit.broad.core.customreports.web.CustomReportActionBean" event="resolveParameters"/>
        </c:if>
        <d:table id="row" class="customreport" requestURI="${uri}" name="${bean.results.rows}" export="true">
            <d:setProperty name="export.csv.filename" value="${bean.report.name}.csv"/>
            <d:setProperty name="export.excel.filename" value="${bean.report.name}.xls"/>
            <d:setProperty name="export.xml.filename" value="${bean.report.name}.xml"/>
            <d:setProperty name="export.pdf.filename" value="${bean.report.name}.pdf"/>

            <d:setProperty name="export.csv.include_header" value="true"/>
            <d:setProperty name="export.excel.include_header" value="true"/>
            <d:setProperty name="export.pdf.include_header" value="true"/>

            <d:column media="html" title="#" style="text-align: right;"><script type="text/JavaScript">document.write(rownum++);</script></d:column>

            <c:forEach var="column" items="${bean.results.dynaProperties}">
                <c:set var="col" scope="request" value="${column}"/>
                <d:column sortable="true"
                          title="<%= WordUtils.capitalizeFully(((DynaProperty) request.getAttribute("col")).getName().replace('_', ' ')) %>"
                          property="${column.name}"/>

            </c:forEach>
        </d:table>
    </c:when>
</c:choose>