<%@ tag import="org.apache.commons.beanutils.DynaProperty"%>
<%@ tag import="org.apache.commons.lang.WordUtils"%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="stripes" uri="http://stripes.sourceforge.net/stripes.tld"%>
<%@ tag body-content="empty" %>

<%@ attribute name="domains"			required="false" type="edu.mit.broad.core.customreports.ReportDomain[]" rtexprvalue="true" %>
<%@ attribute name="chartContextPath"	required="true"  type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="chartDefinitionId"	required="false" type="java.lang.Long" rtexprvalue="true" %>
<%@ attribute name="fullName"			required="true"  type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="view"				required="false"  type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="showChartName"		required="false" type="java.lang.Boolean" rtexprvalue="true" %>
<%@ attribute name="variables" 			required="false" type="java.util.Map" rtexprvalue="true" %>
<%@ attribute name="editingAllowed" 	required="false" type="java.lang.Boolean" rtexprvalue="true" %>
<%@ attribute name="cssTableClass" 		required="false" type="java.lang.String" rtexprvalue="true" %>
<%@ attribute name="cssFormClass" 		required="false" type="java.lang.String" rtexprvalue="true" %>

<c:set var="_custom_reports.domains"      		scope="session" value="${domains}"/>
<c:set var="_custom_reports.chartDefinitionId"  scope="session" value="${chartDefinitionId}"/>
<c:set var="_custom_reports.view"      			scope="session" value="${view}"/>
<c:set var="_custom_reports.fullName"   		scope="session" value="${fullName}"/>
<c:set var="_custom_reports.variables"      	scope="session" value="${variables}"/>

<c:set var="variablesString" value="" />
<c:set var="startString" value="&variables['" />
<c:set var="endString" value="']=" />
<c:forEach items="${variables}" var="entry">
	<c:set var="variablesString" value="${variablesString}${startString}${entry.key}${endString}${entry.value}"/> 
</c:forEach>
<stripes:useActionBean var="bean" beanclass="edu.mit.broad.core.customreports.web.chart.ChartActionBean" />
<c:if test="${empty view}"><c:set var="view" value="${bean.view}" /></c:if>

<c:choose>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View list of all Charts.									         --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${view == 'ShowAllCharts' || view == null}">

    	<script type="text/javascript">
    		function getCheckedValue(radioObj) {
				if(!radioObj)
					return "";
				var radioLength = radioObj.length;
				if(radioLength == undefined)
					if(radioObj.checked)
						return radioObj.value;
					else
						return "";
				for(var i = 0; i < radioLength; i++) {
					if(radioObj[i].checked) {
						return radioObj[i].value;
					}
				}
				return "";
			}
	    	function showChart() {
	    		var chartDefId = getCheckedValue(document.forms['chart.chartForm'].elements['chartDefinitionId']);
	    		var imageHtml = '<img id="graph.reportId.' +chartDefId +'" src="${chartContextPath}/Chart.action?RetrieveSummaryChart=&chartDefinitionId=' +chartDefId +"&fullName=${fullName}${variablesString}" +'" alt="Report Summary Chart"/>';
	    		document.getElementById('chart.viewChart').innerHTML=imageHtml;
	    	}
		</script>

        <div class="customreport-pagetitle">Custom Report Selection</div>
    	<p>
		<ul>
		<li>Select the radio button next to the report name
			and then hit the <em>View</em> or <em>Download</em> button.</li>
		<li>Please use the <em>Download</em> button to get large reports.</li>
		</ul>
		</p>

        <stripes:errors/>
        <stripes:form beanclass="edu.mit.broad.core.customreports.web.chart.ChartActionBean" id="chart.chartForm">
		<table><tr><td valign="top">
			<table class="${cssTableClass}">
			<tr><th>&nbsp;</th><th>Name</th><th>Description</th></tr>
			<c:set var="cnt" value="0" />
			<c:forEach items="${bean.allChartDefs}" var="chartDef">
				<tr ${(cnt % 2 == 0 ? "id=\"even\"" : "id=\"odd\"" )}><td><stripes:radio id="chart.chartDefinitionId" name="chartDefinitionId" value="${chartDef.chartDefinitionId}"/></td><td>${chartDef.name}</td><td>${chartDef.description}</td></tr>
				<c:set var="cnt" value="${cnt +1}" />
			</c:forEach>
			</table></td><td><div id="chart.viewChart"/></tr>
            <tr>
                <td colspan="2">
                    <br />
                    <c:if test="${editingAllowed}">
                        <stripes:submit name="SetupNewChart" value="New" /> &nbsp; &nbsp; &nbsp; 
                        <stripes:submit name="EditChart" value="Edit" /> &nbsp; &nbsp; &nbsp; 
                        <stripes:submit name="DeleteChart" value="Delete" /> &nbsp; &nbsp; &nbsp; 
                    </c:if>
                        <stripes:button name="RetrieveSummaryChart" value="View Chart" onclick="showChart(); return false;" />
                </td>
            </tr>
        </table>
        </stripes:form>
    </c:when>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders the create a new chart.				     --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${view == 'SetupNewChart' || view == 'EditChart'}">
	    <script type="text/javascript">

			function addLoadEvent(func) {
			    var oldonload = window.onload;
			    if (typeof window.onload != 'function') {
			      window.onload = func;
			    } else {
			      window.onload = function() {
			        func();
			        oldonload();
			      }
			    }
			}

	        function toggleShowHideFields() {
				var chartType = document.getElementById('chart.chartType');
			    var rangeAxisLabel = document.getElementById('chart.rangeAxisLabel');
			    var plotOrientation = document.getElementById('chart.plotOrientation');
			    var legend = document.getElementById('chart.legend');
			    var tableOrder = document.getElementById('chart.tableOrder');
			    var binNumber = document.getElementById('chart.binNumber');
			    var overlayStatus = document.getElementById('chart.overlayStatus');

	            if (chartType.options[chartType.selectedIndex].value == "HISTOGRAM") {
	                chartType.style.width = "10em";
	                overlayStatus.style.width = "10em";
	            } else {
	                chartType.style.width = "20em";
	            }

			<c:forEach items="${bean.requiredChartTypeOptions}" var="option">
				if (chartType.options[chartType.selectedIndex].value ==  "${option.chartTypeName}") {
				    if (${option.rangeAxisLabel}) {
				    	rangeAxisLabel.show();
			    	} else {
			    		rangeAxisLabel.hide();
			    	}
			    	if (${option.plotOrientation}) {
				    	plotOrientation.show();
			    	} else {
			    		plotOrientation.hide();
		    		}
				    if (${option.legend}) {
				    	legend.show();
			    	} else {
			    		legend.hide();
			    	}
				    if (${option.tableOrder}) {
				    	tableOrder.show();
			    	} else {
			    		tableOrder.hide();
			    	}
				    if (${option.binNumber}) {
				    	binNumber.show();
			    	} else {
			    		binNumber.hide();
			    	}
				    if (${option.overlayStatus}) {
				    	overlayStatus.show();
			    	} else {
			    		overlayStatus.hide();
			    	}
				}
			</c:forEach>
	        }
	        addLoadEvent(toggleShowHideFields);
	    </script>

        <stripes:form action="${chartContextPath}/Chart.action">
        	<c:if test="${view == 'EditChart'}">
            <stripes:hidden name="chartDefinitionId" id="chart.chartDefinitionId"/>
        	</c:if>
            <table class="${cssFormClass}">
                <tr>
                    <th>Chart Title:</th>
                    <td><stripes:text name="name" id="chart.name" value="${bean.name}"/></td>
                </tr>
                <tr>
                    <th>Chart Type:</th>
                    <td>
                        <stripes:select name="chartType" value="${bean.chartType}" id="chart.chartType" onchange="toggleShowHideFields()">
                            <stripes:options-enumeration enum="edu.mit.broad.core.customreports.chart.CustomReportChartDef.ChartType"/>
                        </stripes:select>
                        <select name="overlayStatus" value="${bean.overlayStatus}" id="chart.overlayStatus">
                            <option value="true">Overlay</option>
                            <option value="false">Tiled</option>
                        </select>
                    </td>
                </tr>
                <tr id="chart.binNumber">
                    <th>Number of Bins:</th>
                    <td><stripes:text name="binNumber" value="${bean.binNumber}" /></td>
                </tr>
                <tr id="chart.rangeAxisLabel">
                	<th>Range Axis Label:</th>
                	<td><stripes:text name="rangeAxisLabel" value="${bean.rangeAxisLabel}" /></td>
                </tr>
                <tr id="chart.plotOrientation">
                	<th>Plot Orientation:</th>
                	<td><stripes:select name="plotOrientation" value="${bean.plotOrientation}">
                            <stripes:option label="Vertical" value="PlotOrientation.VERTICAL"/>
                            <stripes:option label="Horizontal" value="PlotOrientation.HORIZONTAL"/>
                        </stripes:select>
                    </td>
            	</tr>
                <tr id="chart.tableOrder">
                	<th>Table Order:</th>
                	<td><stripes:select name="tableOrder" id="tableOrder" value="${bean.tableOrder}">
                            <stripes:option label="By Column" value="org.jfree.util.TableOrder.BY_COLUMN"/>
                            <stripes:option label="By Row" value="org.jfree.util.TableOrder.BY_ROW"/>
                        </stripes:select>
                    </td>
            	</tr>
            	<tr id="chart.legend">
            		<th>Show Legend:</th>
            		<td>
            			<c:if test="${bean.legend || bean.legend == null}"><input type="radio" name="legend" value="false" /> No &nbsp; &nbsp; <input type="radio" name="legend" value="true" checked="checked" /> Yes</c:if>
            			<c:if test="${!bean.legend && bean.legend != null}"><input type="radio" name="legend" value="false" checked="checked" /> No &nbsp; &nbsp; <input type="radio" name="legend" value="true" /> Yes</c:if>
            		</td>
            	</tr>
                <tr>
                    <th>Description:</th>
                    <td><stripes:textarea name="description" value="${bean.description}" id="chart.description"/></td>
                </tr>
                <tr>
                	<th>Domain:</th>
                	<td><stripes:select name="domain" value="${bean.domain}">
                			<stripes:options-collection collection="${bean.categories}" value="name" label="description"/>
                		</stripes:select>
            		</td>
                </tr>
                <tr>
                    <th>Chart Height:</th>
                    <td><stripes:text name="chartHeight" value="${bean.chartHeight}" id="chart.chartHeight"/></td>
                </tr>
                <tr>
                    <th>Chart Width:</th>
                    <td><stripes:text name="chartWidth" value="${bean.chartWidth}" id="chart.chartWidth"/></td>
                </tr>
                <tr>
                    <th>Charted Report:</th>
                    <td>
                        <stripes:select name="summaryCustomReportId" value="${bean.summaryCustomReportId}" id="chart.summaryCustomReportId">
                            <stripes:options-collection collection="${bean.customReports}" label="name" value="reportId"/>
                        </stripes:select>
                    </td>
                </tr>
                <tr>
                    <th>Downloaded Report:</th>
                    <td>
                        <stripes:select name="fullCustomReportId" value="${bean.fullCustomReportId}" id="chart.fullCustomReportId">
                            <stripes:options-collection collection="${bean.customReports}" label="name" value="reportId"/>
                        </stripes:select>
                    </td>
                </tr>
                <tr>
                    <th>&nbsp;</th>
                    <td>
                        <stripes:submit name="SaveChart" value="Save"/>
                    </td>
                </tr>
            </table>
        </stripes:form>
    </c:when>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders the resulting data.				         --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${view == 'RetrieveSummaryData'}">
		    <script type="text/javascript">
		    	var uri = "${chartContextPath}/Chart.action?RetrieveSummaryData=&chartDefinitionId=${chartDefinitionId}&fullName=${fullName}${variablesString}";
                new Ajax.Updater(
                    'chart.dataTable${chartDefinitionId}',
                    uri,
                    {
                        method: 'get',
                        evalScripts: true,
                        onFailure: function(){
                        	Element.update("chart.message", "Error loading the data");
                        	Element.setStyle("chart.message", {color: "firebrick"});
                    	}
                    }
                    );
			</script>
			<span id="chart.message"></span>
            <table id="chart.dataTable${chartDefinitionId}" <c:if test="${'' != cssTableClass}">class="${cssTableClass}"</c:if>>

            </table>
    </c:when>
    <%-- ------------------------------------------------------------------- --%>
    <%-- View Fragment that renders a single chart.					         --%>
    <%-- ------------------------------------------------------------------- --%>
    <c:when test="${view == 'RetrieveSummaryChart'}">
        <img id="graph.reportId.${chartDefinitionId}" src="${chartContextPath}/Chart.action?RetrieveSummaryChart=&chartDefinitionId=${chartDefinitionId}&fullName=${fullName}${variablesString}" alt="Report Summary Chart"/>
    </c:when>
</c:choose>