package org.broadinstitute.sting.playground.tools;

import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.cmdline.Option;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

import java.io.*;

import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.Utils;

/**
 * Created by IntelliJ IDEA.
 * User: asivache
 * Date: Aug 12, 2009
 * Time: 3:24:46 PM
 * To change this template use File | Settings | File Templates.
 */
public class BamToFastq extends CommandLineProgram {
    @Usage(programVersion="1.0") public String USAGE = "Extracts read sequences and qualities from the input sam/bam file and wirtes them into "+
        "the output file in fastq format. In the RC mode (default is True), if the read is aligned and the alignment is to the reverse strand on the genome, "+
        "the read's sequence from input sam file will be reverse-complemented prior to writing it to fastq in order restore correctly "+
        "the original read sequence as it was generated by the sequencer.";
    @Option(shortName="I", doc="Input file (bam or sam) to extract reads from. If not specified, reads from stdin.",
                optional=true) public File IN = null;
    @Option(shortName="O",doc="Output file (fastq). If not specified, output is printed to stdout.",
            optional=true) public File OUT = null;
    @Option(shortName="RC", doc="re-reverse bases and quals of reads aligned to the negative strand before writing them to fastq", optional=true)
            public Boolean RE_REVERSE = true;

    public static void main(final String[] argv) {
        System.exit(new BamToFastq().instanceMain(argv));
    }

    protected int doWork() {


        InputStream ins = null;
        if ( IN == null ) ins = System.in;
        else {
            try {
                ins = new FileInputStream(IN);
            } catch ( FileNotFoundException ie ) {
                System.out.println("Failed to open input file "+IN+": "+ie.getCause());
                return 1;
            }
        }

        SAMFileReader inReader = new SAMFileReader(ins);
        PrintStream out = null;
        if ( OUT == null ) out = System.out;
        else {
            try {
                out =  new PrintStream(OUT);
            } catch ( FileNotFoundException ie ) {
                System.out.println("Failed to open output file "+OUT+": "+ie.getCause());
                return 1;
            }
        }

        for (SAMRecord read : inReader ) {
            out.println("@" + read.getReadName());
            if ( read.getReadUnmappedFlag() || !RE_REVERSE || !read.getReadNegativeStrandFlag() ) {
                out.println(read.getReadString());
                out.println('+');
                out.println(read.getBaseQualityString());
            } else {
                out.println(BaseUtils.simpleReverseComplement(read.getReadString()));
                out.println('+');
                out.println(Utils.reverse(read.getBaseQualityString()));
            }
        }
        inReader.close();
        out.close();

        return 0;
    }


}
