/*
 * Copyright (c) 2009 The Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package org.broadinstitute.sting.gatk.walkers;

import java.lang.annotation.*;

/**
 * Describes the size of the window into the genome.  Has differing semantics based on
 * the data this annotation is used to describe.
 *
 * @author mhanna
 * @version 0.1
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
public @interface Window {
    /**
     * Controls where the window should start and stop relative to
     * the locus currently being processed.
     * @return start point; default is 0, indicating 'supply only the reference base at the current locus'.
     */
    public int start() default 0;

    /**
     * Controls where the window should start and stop relative to
     * the locus currently being processed.
     * @return stop point; default is 0, indicating 'supply only the reference base at the current locus'.
     */
    public int stop() default 0;
}
