/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.sf.samtools.util.HttpUtils;
import net.sf.samtools.util.SeekableStream;

public class SeekableHTTPStream
extends SeekableStream {
    private long position = 0L;
    private long contentLength = -1L;
    private final URL url;

    public SeekableHTTPStream(URL url) {
        this.url = url;
        String contentLengthString = HttpUtils.getHeaderField(url, "Content-Length");
        if (contentLengthString != null) {
            try {
                this.contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException ignored) {
                System.out.println("WARNING: Invalid content length (" + contentLengthString + "  for: " + url);
                this.contentLength = -1L;
            }
        }
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        HttpURLConnection connection = null;
        InputStream is = null;
        String byteRange = "";
        int n = 0;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            byteRange = "bytes=" + this.position + "-" + endRange;
            connection.setRequestProperty("Range", byteRange);
            is = connection.getInputStream();
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    int n2 = -1;
                    return n2;
                }
                n += count;
            }
            this.position += (long)n;
            int n3 = n;
            return n3;
        }
        catch (IOException e) {
            if (e.getMessage().contains("416") || e instanceof EOFException) {
                if (n < 0) {
                    int n4 = -1;
                    return n4;
                }
                this.position += (long)n;
                this.contentLength = this.position;
                int n5 = n;
                return n5;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() not support for SeekableHTTPStreams");
    }

    @Override
    public String getSource() {
        return this.url.toString();
    }
}

