/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;

public class SAMRecordCoordinateComparator
implements SAMRecordComparator {
    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.fileOrderCompare(samRecord1, samRecord2);
        if (cmp != 0) {
            return cmp;
        }
        if (samRecord1.getReadNegativeStrandFlag() == samRecord2.getReadNegativeStrandFlag()) {
            return samRecord1.getReadName().compareTo(samRecord2.getReadName());
        }
        return samRecord1.getReadNegativeStrandFlag() ? 1 : -1;
    }

    @Override
    public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int refIndex1 = samRecord1.getReferenceIndex();
        int refIndex2 = samRecord2.getReferenceIndex();
        if (refIndex1 == -1) {
            return refIndex2 == -1 ? 0 : 1;
        }
        if (refIndex2 == -1) {
            return -1;
        }
        int cmp = refIndex1 - refIndex2;
        if (cmp != 0) {
            return cmp;
        }
        return samRecord1.getAlignmentStart() - samRecord2.getAlignmentStart();
    }
}

