/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Chunk;

class DiskBasedBAMFileIndex
extends AbstractBAMFileIndex {
    DiskBasedBAMFileIndex(File file) {
        super(file);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        BAMIndexContent queryResults = this.query(referenceIndex, startPos, endPos);
        if (queryResults == null) {
            return null;
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Chunk chunk : queryResults.getAllChunks()) {
            chunkList.add(chunk.clone());
        }
        chunkList = this.optimizeChunkList(chunkList, queryResults.getLinearIndex().getMinimumOffset(startPos));
        return new BAMFileSpan(chunkList);
    }

    @Override
    protected BAMIndexContent getQueryResults(int reference) {
        throw new UnsupportedOperationException();
    }
}

