/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.BinaryCigarCodec;
import net.sf.samtools.BinaryTagCodec;
import net.sf.samtools.Cigar;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.StringUtil;

class BAMRecord
extends SAMRecord {
    private static final int READ_NAME_OFFSET = 0;
    private byte[] mRestOfBinaryData = null;
    private int mReadLength = 0;
    private boolean mReadLengthValid = true;
    private final short mReadNameLength;
    private boolean mReadNameLengthValid = true;
    private final int mCigarLength;
    private boolean mCigarLengthValid = true;
    private boolean mAttributesDecoded = false;
    private boolean mCigarDecoded = false;
    private boolean mBinaryDataStale;

    BAMRecord(SAMFileHeader header, int referenceID, int coordinate, short readNameLength, short mappingQuality, int indexingBin, int cigarLen, int flags, int readLen, int mateReferenceID, int mateCoordinate, int insertSize, byte[] restOfData) {
        super(header);
        this.setReferenceIndex(referenceID);
        this.setAlignmentStart(coordinate);
        this.mReadNameLength = readNameLength;
        this.setMappingQuality(mappingQuality);
        this.mCigarLength = cigarLen;
        this.setFlags(flags);
        this.mReadLength = readLen;
        this.setMateReferenceIndex(mateReferenceID);
        this.setMateAlignmentStart(mateCoordinate);
        this.setInferredInsertSize(insertSize);
        this.mRestOfBinaryData = restOfData;
        super.setReadName(null);
        super.setCigarString(null);
        super.setReadBases(null);
        super.setBaseQualities(null);
        this.setIndexingBin(indexingBin);
        this.mBinaryDataStale = false;
    }

    @Override
    protected void eagerDecode() {
        this.getReadName();
        this.getCigar();
        this.getReadBases();
        this.getBaseQualities();
        this.getBinaryAttributes();
        super.eagerDecode();
        this.mRestOfBinaryData = null;
    }

    @Override
    public byte[] getVariableBinaryRepresentation() {
        if (this.mBinaryDataStale) {
            return null;
        }
        return this.mRestOfBinaryData;
    }

    @Override
    public int getAttributesBinarySize() {
        if (this.mBinaryDataStale || this.mRestOfBinaryData == null) {
            return -1;
        }
        int tagsOffset = this.readNameSize() + this.cigarSize() + this.basesSize() + this.qualsSize();
        return this.mRestOfBinaryData.length - tagsOffset;
    }

    @Override
    public void setReadName(String value) {
        super.setReadName(value);
        this.mBinaryDataStale = true;
        this.mReadNameLengthValid = false;
    }

    @Override
    public void setCigar(Cigar cigar) {
        super.setCigar(cigar);
        this.mBinaryDataStale = true;
        this.mCigarLengthValid = false;
        this.mCigarDecoded = true;
    }

    @Override
    public void setCigarString(String value) {
        super.setCigarString(value);
        this.mBinaryDataStale = true;
        this.mCigarLengthValid = false;
        this.mCigarDecoded = true;
    }

    @Override
    public void setReadBases(byte[] value) {
        super.setReadBases(value);
        this.mBinaryDataStale = true;
        this.mReadLengthValid = false;
    }

    @Override
    public void setBaseQualities(byte[] value) {
        super.setBaseQualities(value);
        this.mBinaryDataStale = true;
    }

    @Override
    protected void setAttribute(short tag, Object value) {
        this.getBinaryAttributes();
        super.setAttribute(tag, value);
        this.mBinaryDataStale = true;
    }

    @Override
    public void clearAttributes() {
        this.mAttributesDecoded = true;
        this.mBinaryDataStale = true;
        super.clearAttributes();
    }

    @Override
    public int getReadLength() {
        if (this.mReadLengthValid) {
            return this.mReadLength;
        }
        return super.getReadLength();
    }

    @Override
    public String getReadName() {
        String result = super.getReadName();
        if (this.mRestOfBinaryData != null && result == null) {
            result = this.decodeReadName();
            super.setReadName(result);
        }
        return result;
    }

    @Override
    public int getReadNameLength() {
        if (this.mReadNameLengthValid) {
            return this.mReadNameLength - 1;
        }
        return super.getReadNameLength();
    }

    @Override
    public Cigar getCigar() {
        if (this.mRestOfBinaryData != null && !this.mCigarDecoded) {
            int cigarOffset = this.readNameSize();
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.mRestOfBinaryData, cigarOffset, this.cigarSize());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            super.initializeCigar(BinaryCigarCodec.getSingleton().decode(byteBuffer));
            this.mCigarDecoded = true;
            if (this.getValidationStringency() != SAMFileReader.ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
                SAMUtils.processValidationErrors(this.validateCigar(-1L), -1L, this.getValidationStringency());
            }
        }
        return super.getCigar();
    }

    @Override
    public int getCigarLength() {
        if (this.mCigarLengthValid) {
            return this.mCigarLength;
        }
        return super.getCigarLength();
    }

    @Override
    public byte[] getReadBases() {
        byte[] result = super.getReadBases();
        if (this.mRestOfBinaryData != null && result == null) {
            result = this.decodeReadBases();
            super.setReadBases(result);
        }
        return result;
    }

    @Override
    public byte[] getBaseQualities() {
        byte[] ret = super.getBaseQualities();
        if (this.mRestOfBinaryData != null && ret == null) {
            ret = this.decodeBaseQualities();
            super.setBaseQualities(ret);
        }
        return ret;
    }

    @Override
    protected Object getAttribute(short tag) {
        if (!this.mAttributesDecoded) {
            this.decodeAttributes();
        }
        return super.getAttribute(tag);
    }

    @Override
    protected List<SAMBinaryTagAndValue> getBinaryAttributes() {
        if (!this.mAttributesDecoded) {
            this.decodeAttributes();
        }
        return super.getBinaryAttributes();
    }

    private void decodeAttributes() {
        if (this.mAttributesDecoded) {
            return;
        }
        this.mAttributesDecoded = true;
        ArrayList<SAMBinaryTagAndValue> attributes = new ArrayList<SAMBinaryTagAndValue>();
        int tagsOffset = this.readNameSize() + this.cigarSize() + this.basesSize() + this.qualsSize();
        int tagsSize = this.mRestOfBinaryData.length - tagsOffset;
        BinaryTagCodec.readTags(attributes, this.mRestOfBinaryData, tagsOffset, tagsSize, this.getValidationStringency());
        this.setAttributes(attributes);
    }

    private byte[] decodeBaseQualities() {
        if (this.mReadLength == 0) {
            return SAMRecord.NULL_QUALS;
        }
        int qualsOffset = this.readNameSize() + this.cigarSize() + this.basesSize();
        byte[] ret = new byte[this.qualsSize()];
        System.arraycopy(this.mRestOfBinaryData, qualsOffset, ret, 0, this.qualsSize());
        if (ret.length > 0 && ret[0] == -1) {
            return NULL_QUALS;
        }
        return ret;
    }

    private String decodeReadName() {
        return StringUtil.bytesToString(this.mRestOfBinaryData, 0, this.mReadNameLength - 1);
    }

    private byte[] decodeReadBases() {
        if (this.mReadLength == 0) {
            return NULL_SEQUENCE;
        }
        int basesOffset = this.readNameSize() + this.cigarSize();
        return SAMUtils.compressedBasesToBytes(this.mReadLength, this.mRestOfBinaryData, basesOffset);
    }

    private int readNameSize() {
        return this.mReadNameLength;
    }

    private int cigarSize() {
        return this.mCigarLength * 4;
    }

    private int basesSize() {
        return (this.mReadLength + 1) / 2;
    }

    private int qualsSize() {
        return this.mReadLength;
    }
}

