/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataOutputStream;
import java.io.File;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileIndexWriter;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedOutputStream;

class BAMFileWriter
extends SAMFileWriterImpl {
    private final BinaryCodec outputBinaryCodec;
    private BAMRecordCodec bamRecordCodec = null;
    private final BlockCompressedOutputStream blockCompressedOutputStream;
    private BAMFileIndexWriter bamIndexWriter = null;

    public BAMFileWriter(File path) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(path);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(path.toString());
    }

    public BAMFileWriter(File path, int compressionLevel) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(path, compressionLevel);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(path.toString());
    }

    private void prepareToWriteAlignments() {
        if (this.bamRecordCodec == null) {
            this.bamRecordCodec = new BAMRecordCodec(this.getFileHeader());
            this.bamRecordCodec.setOutputStream(this.outputBinaryCodec.getOutputStream());
        }
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        this.prepareToWriteAlignments();
        long startCoordinate = 0L;
        this.bamRecordCodec.encode(alignment);
    }

    @Override
    protected void writeHeader(String textHeader) {
        this.outputBinaryCodec.writeBytes(BAMFileConstants.BAM_MAGIC);
        this.outputBinaryCodec.writeString(textHeader, true, false);
        this.outputBinaryCodec.writeInt(this.getFileHeader().getSequenceDictionary().size());
        for (SAMSequenceRecord sequenceRecord : this.getFileHeader().getSequenceDictionary().getSequences()) {
            this.outputBinaryCodec.writeString(sequenceRecord.getSequenceName(), true, true);
            this.outputBinaryCodec.writeInt(sequenceRecord.getSequenceLength());
        }
    }

    @Override
    protected void finish() {
        this.outputBinaryCodec.close();
        if (this.bamIndexWriter != null) {
            try {
                this.bamIndexWriter.finish();
                this.bamIndexWriter.writeBinary(true, 0L);
            }
            catch (Exception e) {
                System.err.println("Exception writing BAM index file " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String getFilename() {
        return this.outputBinaryCodec.getOutputFileName();
    }
}

