/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class BAMFileIndexWriter
extends AbstractBAMFileIndex {
    private final BAMIndexContent[] content;
    private final int n_ref;
    private final SortedMap<Integer, List<Bin>> referenceToBins = new TreeMap<Integer, List<Bin>>();
    private final SortedMap<Bin, List<Chunk>> binToChunks = new TreeMap<Bin, List<Chunk>>();
    private final SortedMap<Integer, List<LinearIndexItem>> referenceToIndexEntries = new TreeMap<Integer, List<LinearIndexItem>>();
    private final File OUTPUT;

    public BAMFileIndexWriter(File OUTPUT, int nReferences) {
        super(null);
        this.OUTPUT = OUTPUT;
        this.n_ref = nReferences;
        this.content = new BAMIndexContent[this.n_ref];
    }

    public int createIndex(File INPUT, boolean createText, boolean sortBins) {
        SAMFileReader reader = new SAMFileReader(INPUT);
        reader.enableFileSource(true);
        int count = 0;
        int localCount = 0;
        int totalRecords = 0;
        int reference = 0;
        int lastReference = 0;
        SAMRecordIterator it = reader.iterator();
        while (it.hasNext()) {
            SAMRecord rec;
            if (++totalRecords % 1000000 == 0) {
                this.verbose(totalRecords + " reads processed ...");
            }
            if ((rec = (SAMRecord)it.next()).getAlignmentStart() == 0) continue;
            reference = rec.getReferenceIndex();
            if (reference != lastReference) {
                this.processReference(lastReference);
                lastReference = reference;
                localCount = 0;
            }
            ++count;
            ++localCount;
            this.processAlignment(rec);
        }
        it.close();
        this.processReference(lastReference);
        this.verbose("There are " + count + " aligned records in the input BAM file " + INPUT);
        this.deleteIndex();
        try {
            if (createText) {
                this.writeText(sortBins);
            } else {
                this.writeBinary(sortBins, INPUT.length());
            }
        }
        catch (Exception e) {
            this.deleteIndex();
            throw new SAMException("Exception creating index " + e.getMessage());
        }
        return count;
    }

    public void deleteIndex() {
        this.OUTPUT.delete();
    }

    public void writeText(boolean sortBins) throws Exception {
        this.writeText(this.n_ref, this.OUTPUT, sortBins);
    }

    public void writeBinary(boolean sortBins, long bamFileSize) throws Exception {
        this.writeBinary(this.n_ref, this.OUTPUT, sortBins, bamFileSize);
    }

    public void processAlignment(SAMRecord rec) {
        int binNumber = rec.getIndexingBin() == null ? rec.computeIndexingBin() : rec.getIndexingBin().intValue();
        int reference = rec.getReferenceIndex();
        Bin bin = new Bin(reference, binNumber);
        ArrayList<Bin> binList = (ArrayList<Bin>)this.referenceToBins.get(reference);
        if (binList == null) {
            binList = new ArrayList<Bin>();
            this.referenceToBins.put(reference, binList);
        }
        if (!binList.contains(bin)) {
            binList.add(bin);
        }
        if (rec.getFileSource() == null) {
            System.err.println("No source for BAM Record " + rec);
            return;
        }
        BAMFileSpan newSpan = (BAMFileSpan)rec.getFileSource().getFilePointer();
        if (newSpan != null) {
            ArrayList<Chunk> chunks = (ArrayList<Chunk>)this.binToChunks.get(bin);
            if (chunks == null) {
                chunks = new ArrayList<Chunk>();
                this.binToChunks.put(bin, chunks);
            }
            for (Chunk c : newSpan.getChunks()) {
                chunks.add(c);
            }
        } else {
            this.deleteIndex();
            throw new SAMException("Null coordinates on record " + rec + " in reference " + reference);
        }
        if (binNumber < this.getFirstBinInLevel(this.getNumIndexLevels() - 1)) {
            long iOffset = ((BAMFileSpan)rec.getFileSource().getFilePointer()).toCoordinateArray()[0];
            int alignmentStart = rec.getAlignmentStart() - 1;
            int window = LinearIndex.convertToLinearIndexOffset(alignmentStart);
            List indexList = (List)this.referenceToIndexEntries.get(reference);
            if (indexList == null) {
                this.referenceToIndexEntries.put(reference, new ArrayList());
                indexList = (List)this.referenceToIndexEntries.get(reference);
            }
            boolean replaceIndex = true;
            for (LinearIndexItem li : indexList) {
                if (li.window != window) continue;
                if (li.offset < iOffset) {
                    replaceIndex = false;
                    break;
                }
                indexList.remove(li);
                break;
            }
            if (replaceIndex) {
                indexList.add(new LinearIndexItem(window, iOffset));
            }
        }
    }

    public void finish() {
        for (int i = 0; i < this.n_ref; ++i) {
            this.processReference(i);
        }
    }

    private void processReference(int reference) {
        List binList = (List)this.referenceToBins.get(reference);
        if (binList == null) {
            return;
        }
        for (Bin bin : binList) {
            List<Chunk> chunkList = (List<Chunk>)this.binToChunks.get(bin);
            if (chunkList == null) continue;
            chunkList = this.optimizeChunkList(chunkList, 0L);
            this.binToChunks.put(bin, chunkList);
        }
        LinearIndex linearIndex = this.computeLinearIndex(reference);
        this.content[reference] = new BAMIndexContent(reference, binList, this.binToChunks, linearIndex);
    }

    private LinearIndex computeLinearIndex(int reference) {
        LinearIndex linearIndex;
        List indexList = (List)this.referenceToIndexEntries.get(reference);
        if (indexList == null) {
            linearIndex = null;
        } else {
            int maxWindow = 0;
            for (LinearIndexItem l : indexList) {
                maxWindow = Math.max(maxWindow, l.window);
            }
            long[] newIndex = new long[maxWindow + 1];
            Arrays.fill(newIndex, 0L);
            for (LinearIndexItem l : indexList) {
                newIndex[l.window] = l.offset;
            }
            linearIndex = new LinearIndex(reference, 1, newIndex);
        }
        return linearIndex;
    }

    @Override
    protected BAMIndexContent getQueryResults(int reference) {
        return this.content[reference];
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        throw new UnsupportedOperationException();
    }

    private void verbose(String message) {
        boolean verbose = true;
        if (verbose) {
            System.out.println("BAMFileIndexWriter: " + message);
        }
    }

    private class LinearIndexItem {
        public final int window;
        public final long offset;

        public LinearIndexItem(int window, long offset) {
            this.window = window;
            this.offset = offset;
        }
    }
}

