/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;

class Chunk
implements Cloneable,
Serializable,
Comparable<Chunk> {
    private static final long serialVersionUID = 1L;
    private long mChunkStart;
    private long mChunkEnd;

    public Chunk(long start, long end) {
        this.mChunkStart = start;
        this.mChunkEnd = end;
    }

    public Chunk clone() {
        return new Chunk(this.mChunkStart, this.mChunkEnd);
    }

    protected long getChunkStart() {
        return this.mChunkStart;
    }

    protected void setChunkStart(long value) {
        this.mChunkStart = value;
    }

    protected long getChunkEnd() {
        return this.mChunkEnd;
    }

    protected void setChunkEnd(long value) {
        this.mChunkEnd = value;
    }

    @Override
    public int compareTo(Chunk chunk) {
        int result = Long.signum(this.mChunkStart - chunk.mChunkStart);
        if (result == 0) {
            result = Long.signum(this.mChunkEnd - chunk.mChunkEnd);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        if (this.mChunkEnd != chunk.mChunkEnd) {
            return false;
        }
        return this.mChunkStart == chunk.mChunkStart;
    }

    public int hashCode() {
        int result = (int)(this.mChunkStart ^ this.mChunkStart >>> 32);
        result = 31 * result + (int)(this.mChunkEnd ^ this.mChunkEnd >>> 32);
        return result;
    }

    public String toString() {
        return String.format("%d:%d-%d:%d", this.mChunkStart >> 16, this.mChunkStart & 0xFFFFL, this.mChunkEnd >> 16, this.mChunkEnd & 0xFFFFL);
    }
}

