/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.WeakHashMap;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Bin;
import net.sf.samtools.BinList;
import net.sf.samtools.BrowseableBAMIndex;
import net.sf.samtools.Chunk;

class CachingBAMFileIndex
extends AbstractBAMFileIndex
implements BrowseableBAMIndex {
    private Integer mLastReferenceRetrieved = null;
    private WeakHashMap<Integer, BAMIndexContent> mQueriesByReference = new WeakHashMap();

    public CachingBAMFileIndex(File file) {
        super(file);
    }

    @Override
    public void close() {
        super.close();
        this.mLastReferenceRetrieved = null;
        this.mQueriesByReference.clear();
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        BAMIndexContent queryResults = this.getQueryResults(referenceIndex);
        if (queryResults == null) {
            return null;
        }
        BinList overlappingBins = this.getBinsOverlapping(referenceIndex, startPos, endPos);
        ArrayList<Bin> bins = new ArrayList<Bin>();
        for (Bin bin : queryResults.getBins()) {
            if (!overlappingBins.getBins().get(bin.getBinNumber())) continue;
            bins.add(bin);
        }
        if (bins.isEmpty()) {
            return null;
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Bin bin : bins) {
            for (Chunk chunk : queryResults.getChunksForBin(bin)) {
                chunkList.add(chunk.clone());
            }
        }
        if (chunkList.isEmpty()) {
            return null;
        }
        chunkList = this.optimizeChunkList(chunkList, queryResults.getLinearIndex().getMinimumOffset(startPos));
        return new BAMFileSpan(chunkList);
    }

    @Override
    public BinList getBinsOverlapping(int referenceIndex, int startPos, int endPos) {
        BitSet regionBins = this.regionToBins(startPos, endPos);
        if (regionBins == null) {
            return null;
        }
        return new BinList(referenceIndex, regionBins);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        if (bin == null) {
            return null;
        }
        int referenceSequence = bin.getReferenceSequence();
        BAMIndexContent indexQuery = this.getQueryResults(referenceSequence);
        if (indexQuery == null) {
            return null;
        }
        int binLevel = this.getLevelForBin(bin);
        int firstLocusInBin = this.getFirstLocusInBin(bin);
        ArrayList<Bin> binTree = new ArrayList<Bin>();
        if (indexQuery.containsBin(bin)) {
            binTree.add(bin);
        }
        int currentBinLevel = binLevel;
        while (--currentBinLevel >= 0) {
            int binStart = this.getFirstBinInLevel(currentBinLevel);
            int binWidth = this.getMaxAddressibleGenomicLocation() / this.getLevelSize(currentBinLevel);
            int binNumber = firstLocusInBin / binWidth + binStart;
            Bin parentBin = new Bin(bin.getReferenceSequence(), binNumber);
            if (!indexQuery.containsBin(parentBin)) continue;
            binTree.add(parentBin);
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Bin coveringBin : binTree) {
            for (Chunk chunk : indexQuery.getChunksForBin(coveringBin)) {
                chunkList.add(chunk.clone());
            }
        }
        int start = this.getFirstLocusInBin(bin);
        chunkList = this.optimizeChunkList(chunkList, indexQuery.getLinearIndex().getMinimumOffset(start));
        return new BAMFileSpan(chunkList);
    }

    @Override
    protected BAMIndexContent getQueryResults(int referenceIndex) {
        if (this.mLastReferenceRetrieved != null && this.mLastReferenceRetrieved == referenceIndex) {
            return this.mQueriesByReference.get(referenceIndex);
        }
        BAMIndexContent queryResults = this.mQueriesByReference.get(referenceIndex);
        if (queryResults != null) {
            this.mLastReferenceRetrieved = referenceIndex;
            this.mQueriesByReference.put(referenceIndex, queryResults);
            return queryResults;
        }
        queryResults = this.query(referenceIndex, 1, -1);
        if (queryResults != null) {
            this.mLastReferenceRetrieved = referenceIndex;
            this.mQueriesByReference.put(referenceIndex, queryResults);
            return queryResults;
        }
        return null;
    }
}

