/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;

class BAMIndexContent {
    private final int mReferenceSequence;
    private final List<Bin> mBins;
    private final SortedMap<Bin, List<Chunk>> mBinToChunks;
    private final LinearIndex mLinearIndex;

    public BAMIndexContent(int referenceSequence, List<Bin> bins, SortedMap<Bin, List<Chunk>> binToChunks, LinearIndex linearIndex) {
        this.mReferenceSequence = referenceSequence;
        this.mBins = bins;
        this.mBinToChunks = binToChunks;
        this.mLinearIndex = linearIndex;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public boolean containsBin(Bin bin) {
        return Collections.binarySearch(this.mBins, bin) >= 0;
    }

    public List<Bin> getBins() {
        return Collections.unmodifiableList(this.mBins);
    }

    public List<Chunk> getChunksForBin(Bin bin) {
        if (!this.mBinToChunks.containsKey(bin)) {
            throw new SAMException("No chunks found for the given bin.");
        }
        return Collections.unmodifiableList((List)this.mBinToChunks.get(bin));
    }

    public List<Chunk> getAllChunks() {
        ArrayList<Chunk> allChunks = new ArrayList<Chunk>();
        for (List<Chunk> moreChunks : this.mBinToChunks.values()) {
            allChunks.addAll(moreChunks);
        }
        return Collections.unmodifiableList(allChunks);
    }

    public LinearIndex getLinearIndex() {
        return this.mLinearIndex;
    }

    public void writeText(PrintWriter pw, boolean sortBins) {
        if (this.mBins == null || this.mBins.size() == 0) {
            BAMIndexContent.writeNullTextContent(pw, this.mReferenceSequence);
            return;
        }
        int size = this.mBins.size();
        pw.println("Reference " + this.mReferenceSequence + " has n_bin= " + size);
        Object[] bins = new Bin[size];
        if (size != 0) {
            this.getBins().toArray(bins);
        }
        if (sortBins) {
            Arrays.sort(bins);
        }
        for (int j = 0; j < size; ++j) {
            if (this.mBinToChunks.get(bins[j]) == null) {
                pw.println("  Ref " + this.mReferenceSequence + " bin " + ((Bin)bins[j]).getBinNumber() + " has no mBinToChunks");
                continue;
            }
            List chunkList = (List)this.mBinToChunks.get(bins[j]);
            if (chunkList == null) {
                pw.println("  Ref " + this.mReferenceSequence + " bin " + ((Bin)bins[j]).getBinNumber() + " has no chunkList");
                continue;
            }
            pw.print("  Ref " + this.mReferenceSequence + " bin " + ((Bin)bins[j]).getBinNumber() + " has n_chunk= " + chunkList.size());
            for (Chunk c : chunkList) {
                pw.println("     Chunk: " + c.toString() + " start: " + Long.toString(c.getChunkStart(), 16) + " end: " + Long.toString(c.getChunkEnd(), 16));
            }
        }
        if (this.mLinearIndex == null || this.mLinearIndex.getIndexEntries() == null) {
            pw.println("Reference " + this.mReferenceSequence + " has n_intv= 0");
            return;
        }
        long[] entries = this.mLinearIndex.getIndexEntries();
        int indexStart = this.mLinearIndex.getIndexStart();
        int n_intv = entries.length + indexStart;
        pw.println("Reference " + this.mReferenceSequence + " has n_intv= " + n_intv);
        for (int k = 0; k < entries.length; ++k) {
            if (entries[k] == 0L) continue;
            pw.println("ioffset for " + (k + indexStart) + " is " + Long.toString(entries[k]));
        }
    }

    public void writeBinary(ByteBuffer bb, boolean sortBins) {
        if (this.mBins == null || this.mBins.size() == 0) {
            BAMIndexContent.writeNullBinaryContent(bb);
            return;
        }
        int size = this.mBins.size();
        bb.putInt(size);
        Object[] bins = new Bin[size];
        if (size != 0) {
            this.getBins().toArray(bins);
        }
        if (sortBins) {
            Arrays.sort(bins);
        }
        for (int j = 0; j < size; ++j) {
            bb.putInt(((Bin)bins[j]).getBinNumber());
            if (this.mBinToChunks.get(bins[j]) == null) continue;
            List chunkList = (List)this.mBinToChunks.get(bins[j]);
            int n_chunk = chunkList.size();
            bb.putInt(n_chunk);
            for (Chunk c : chunkList) {
                bb.putLong(c.getChunkStart());
                bb.putLong(c.getChunkEnd());
            }
        }
        long[] entries = this.mLinearIndex == null ? null : this.mLinearIndex.getIndexEntries();
        int indexStart = this.mLinearIndex == null ? 0 : this.mLinearIndex.getIndexStart();
        int n_intv = entries == null ? indexStart : entries.length + indexStart;
        bb.putInt(n_intv);
        if (entries == null) {
            return;
        }
        for (int i = 0; i < indexStart; ++i) {
            bb.putLong(0L);
        }
        for (int k = 0; k < entries.length; ++k) {
            bb.putLong(entries[k]);
        }
    }

    static void writeNullTextContent(PrintWriter pw, int reference) {
        pw.println("Reference " + reference + " has n_bin=0");
        pw.println("Reference " + reference + " has n_intv=0");
    }

    static void writeNullBinaryContent(ByteBuffer bb) {
        bb.putInt(0);
        bb.putInt(0);
    }
}

