/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Log {
    private static LogLevel globalLogLevel = LogLevel.DEBUG;
    private final Class<?> clazz;
    private final String className;
    private final PrintStream out = System.out;

    private Log(Class<?> clazz) {
        this.clazz = clazz;
        this.className = clazz.getSimpleName();
    }

    public static Log getInstance(Class<?> clazz) {
        return new Log(clazz);
    }

    public static void setGlobalLogLevel(LogLevel logLevel) {
        globalLogLevel = logLevel;
    }

    public final boolean isEnabled(LogLevel level) {
        return level.ordinal() <= globalLogLevel.ordinal();
    }

    private void emit(LogLevel level, Throwable throwable, Object ... parts) {
        if (this.isEnabled(level)) {
            this.out.print(level.name());
            this.out.print('\t');
            this.out.print(this.getTimestamp());
            this.out.print('\t');
            this.out.print(this.className);
            this.out.print('\t');
            for (Object part : parts) {
                if (part != null && part.getClass().isArray()) {
                    Class<?> component = part.getClass().getComponentType();
                    if (component.equals(Boolean.TYPE)) {
                        this.out.print(Arrays.toString((boolean[])part));
                        continue;
                    }
                    if (component.equals(Byte.TYPE)) {
                        this.out.print(Arrays.toString((byte[])part));
                        continue;
                    }
                    if (component.equals(Character.TYPE)) {
                        this.out.print(Arrays.toString((char[])part));
                        continue;
                    }
                    if (component.equals(Double.TYPE)) {
                        this.out.print(Arrays.toString((double[])part));
                        continue;
                    }
                    if (component.equals(Float.TYPE)) {
                        this.out.print(Arrays.toString((float[])part));
                        continue;
                    }
                    if (component.equals(Integer.TYPE)) {
                        this.out.print(Arrays.toString((int[])part));
                        continue;
                    }
                    if (component.equals(Long.TYPE)) {
                        this.out.print(Arrays.toString((long[])part));
                        continue;
                    }
                    if (component.equals(Short.TYPE)) {
                        this.out.print(Arrays.toString((short[])part));
                        continue;
                    }
                    this.out.print(Arrays.toString((Object[])part));
                    continue;
                }
                this.out.print(part);
            }
            this.out.println();
            if (throwable != null) {
                throwable.printStackTrace(this.out);
            }
        }
    }

    protected String getTimestamp() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return fmt.format(new Date());
    }

    public final void error(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.ERROR, throwable, messageParts);
    }

    public final void warn(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.WARNING, throwable, messageParts);
    }

    public final void info(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.INFO, throwable, messageParts);
    }

    public final void debug(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.DEBUG, throwable, messageParts);
    }

    public final void error(Object ... messageParts) {
        this.emit(LogLevel.ERROR, null, messageParts);
    }

    public final void warn(Object ... messageParts) {
        this.emit(LogLevel.WARNING, null, messageParts);
    }

    public final void info(Object ... messageParts) {
        this.emit(LogLevel.INFO, null, messageParts);
    }

    public final void debug(Object ... messageParts) {
        this.emit(LogLevel.DEBUG, null, messageParts);
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

