/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.variation.VariantType;
import java.util.regex.Pattern;

public class KnownVariant
implements Comparable<KnownVariant> {
    private final String name;
    private final int sequenceIndex;
    private final int startPos;
    private final int endPos;
    private final VariantType type;
    private final boolean validated;
    private transient String referenceSequence;
    private final String observedAlleles;
    private final Float minorAlleleFrequency;
    public static final Pattern separator = Pattern.compile("\\/");

    public KnownVariant(String name, int sequenceIndex, int startPos, int endPos, VariantType type, boolean validated) {
        this(name, sequenceIndex, startPos, endPos, type, validated, null, null);
    }

    public KnownVariant(String name, int sequenceIndex, int startPos, int endPos, VariantType type, boolean validated, String observedAlleles, Float minorAlleleFrequency) {
        this.name = name;
        this.sequenceIndex = sequenceIndex;
        this.startPos = startPos;
        this.endPos = endPos;
        this.type = type;
        this.validated = validated;
        this.observedAlleles = observedAlleles;
        this.minorAlleleFrequency = minorAlleleFrequency;
    }

    @Override
    public int compareTo(KnownVariant that) {
        int retVal = this.getSequenceIndex() - that.getSequenceIndex();
        if (retVal == 0) {
            retVal = this.startPos - that.startPos;
        }
        if (retVal == 0) {
            retVal = this.endPos - that.endPos;
        }
        if (retVal == 0) {
            retVal = this.getName().compareTo(that.getName());
        }
        if (retVal == 0) {
            retVal = this.getType().compareTo(that.getType());
        }
        if (retVal == 0) {
            if (this.isValidated() && !that.isValidated()) {
                retVal = 1;
            } else if (!this.isValidated() && that.isValidated()) {
                retVal = -1;
            }
        }
        if (retVal == 0) {
            if (this.observedAlleles != null && that.observedAlleles == null) {
                retVal = 1;
            } else if (this.observedAlleles == null && that.observedAlleles != null) {
                retVal = -1;
            } else if (this.observedAlleles != null && that.observedAlleles != null) {
                retVal = this.observedAlleles.compareTo(that.observedAlleles);
            }
        }
        if (retVal == 0) {
            if (this.minorAlleleFrequency != null && that.minorAlleleFrequency == null) {
                retVal = 1;
            } else if (this.minorAlleleFrequency == null && that.minorAlleleFrequency != null) {
                retVal = -1;
            } else if (this.minorAlleleFrequency != null && that.minorAlleleFrequency != null) {
                retVal = this.minorAlleleFrequency.compareTo(that.minorAlleleFrequency);
            }
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KnownVariant)) {
            return false;
        }
        KnownVariant that = (KnownVariant)o;
        return this.name.equals(that.name) && this.sequenceIndex == that.sequenceIndex && this.startPos == that.startPos && this.endPos == that.endPos && this.type == that.type && this.validated == that.validated && (this.minorAlleleFrequency == null && that.minorAlleleFrequency == null || this.minorAlleleFrequency != null && that.minorAlleleFrequency != null && Float.floatToIntBits(this.minorAlleleFrequency.floatValue()) == Float.floatToIntBits(that.minorAlleleFrequency.floatValue())) && (this.observedAlleles == null && that.observedAlleles == null || this.observedAlleles != null && that.observedAlleles != null && this.observedAlleles.equals(that.observedAlleles));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.name.hashCode();
        result = 37 * result + this.sequenceIndex;
        result = 37 * result + this.startPos;
        result = 37 * result + this.endPos;
        result = 37 * result + this.type.hashCode();
        result = 37 * result + (this.validated ? 1 : 0);
        if (this.observedAlleles != null) {
            result = 37 * result + this.observedAlleles.hashCode();
        }
        if (this.minorAlleleFrequency != null) {
            result = 37 * result + Float.floatToIntBits(this.minorAlleleFrequency.floatValue());
        }
        return result;
    }

    public String[] getObservedAlleles() {
        return this.observedAlleles != null ? separator.split(this.observedAlleles) : new String[]{};
    }

    public String getName() {
        return this.name;
    }

    public int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public String getReferenceSequence() {
        return this.referenceSequence;
    }

    public void setReferenceSequence(String referenceSequence) {
        this.referenceSequence = referenceSequence;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public VariantType getType() {
        return this.type;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String getObservedAllelesString() {
        return this.observedAlleles;
    }

    public Float getMinorAlleleFrequency() {
        return this.minorAlleleFrequency;
    }
}

