/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.variation.DbSnpFileGenerator;
import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;

public class GenerateDbSnpFile
extends CommandLineProgram {
    @Usage
    public String USAGE = "Usage: " + this.getClass().getName() + " [options]\n\n" + "Generate a KnownVariant binary file from a UCSC DbSnp text file.\n";
    @Option(shortName="S", doc="UCSC SNP file. ")
    public File SNP_FILE;
    @Option(shortName="SD", doc="Sequence Dictionary for the genome in SAM or BAM format. ")
    public File SEQUENCE_DICTIONARY;
    @Option(shortName="O", doc="The binary output file. ")
    public File OUTPUT;
    @Option(doc="If set to true, remove leading 'chr' prefixes from chromosome names")
    public boolean REMOVE_CHR_PREFIX = false;

    @Override
    protected int doWork() {
        DbSnpFileGenerator generator = new DbSnpFileGenerator(this.SNP_FILE, this.SEQUENCE_DICTIONARY, this.OUTPUT);
        generator.setRemoveChrPrefix(this.REMOVE_CHR_PREFIX);
        generator.writeDbSnpFile();
        return 0;
    }

    public static void main(String[] argv) {
        System.exit(new GenerateDbSnpFile().instanceMain(argv));
    }
}

