/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.variation.KnownVariant;
import edu.mit.broad.picard.variation.KnownVariantCodec;
import edu.mit.broad.picard.variation.KnownVariantCodecFactory;
import edu.mit.broad.picard.variation.KnownVariantFileHeader;
import edu.mit.broad.picard.variation.KnownVariantIterator;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMSequenceRecord;

public class DbSnpFileReader
implements KnownVariantIterator {
    private final File dbSnpFile;
    private KnownVariantCodec kvCodec;
    List<SAMSequenceRecord> dictionary;
    private final Map<Integer, SAMSequenceRecord> refIndexToName = new HashMap<Integer, SAMSequenceRecord>();
    private KnownVariant next = null;
    private int dbSnpCount = -1;
    private String sourceFile = null;

    public DbSnpFileReader(File dbSnpFile) {
        this.dbSnpFile = dbSnpFile;
        this.kvCodec = KnownVariantCodecFactory.makeKnownVariantCodec(dbSnpFile);
        this.readHeader();
        this.next = this.readNextDbSnp();
    }

    @Override
    public Iterator<KnownVariant> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public KnownVariant next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KnownVariant result = this.next;
        this.next = this.readNextDbSnp();
        return result;
    }

    public KnownVariant peek() {
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported.");
    }

    public void close() {
        this.kvCodec.close();
    }

    private void readHeader() {
        KnownVariantFileHeader header = this.kvCodec.decodeKnownVariantFileHeader();
        this.dictionary = header.getSequenceDictionary();
        for (int i = 0; i < this.dictionary.size(); ++i) {
            this.refIndexToName.put(i, this.dictionary.get(i));
        }
        this.dbSnpCount = header.getDbSnpCount();
        this.sourceFile = header.getSourceFile();
    }

    private KnownVariant readNextDbSnp() {
        KnownVariant kv = this.kvCodec.decodeKnownVariant();
        if (kv != null) {
            kv.setReferenceSequence(this.refIndexToName.get(kv.getSequenceIndex()).getSequenceName());
        }
        return kv;
    }

    @Override
    public List<SAMSequenceRecord> getSequenceDictionary() {
        return this.dictionary;
    }

    public int getCountDbSnpRecords() {
        return this.dbSnpCount;
    }

    public File getDbSnpFile() {
        return this.dbSnpFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }
}

