/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.util.TabbedTextFileParser;
import edu.mit.broad.picard.variation.KnownVariant;
import edu.mit.broad.picard.variation.KnownVariantCodec;
import edu.mit.broad.picard.variation.KnownVariantCodecFactory;
import edu.mit.broad.picard.variation.KnownVariantFileHeader;
import edu.mit.broad.picard.variation.VariantType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;

public class DbSnpFileGenerator {
    static final String snp = "single";
    static final String insertion = "insertion";
    static final String deletion = "deletion";
    static final String indel = "in-del";
    private final File snpFile;
    private final File seqDictionaryFile;
    private final Map<String, Integer> sequenceToIndex = new HashMap<String, Integer>();
    private SAMSequenceDictionary dictionary;
    private KnownVariantCodec kvCodec;
    private Map<String, SortedSet<KnownVariant>> sequenceToSnps;
    private boolean removeChrPrefix = false;
    private final Log log = Log.getInstance(DbSnpFileGenerator.class);

    DbSnpFileGenerator(File snpFile, File seqDictionaryFile, File outputFile) {
        this(snpFile, seqDictionaryFile, outputFile, "DBS\u0002");
    }

    DbSnpFileGenerator(File snpFile, File seqDictionaryFile, File outputFile, String magicNumber) {
        this.snpFile = snpFile;
        this.seqDictionaryFile = seqDictionaryFile;
        this.kvCodec = KnownVariantCodecFactory.makeKnownVariantCodec(outputFile, magicNumber);
    }

    public void setRemoveChrPrefix(boolean removeChrPrefix) {
        this.removeChrPrefix = removeChrPrefix;
    }

    public void writeDbSnpFile() {
        SAMFileReader sam = new SAMFileReader(this.seqDictionaryFile);
        this.dictionary = sam.getFileHeader().getSequenceDictionary();
        this.sequenceToSnps = new HashMap<String, SortedSet<KnownVariant>>();
        int count = 0;
        TabbedTextFileParser parser = new TabbedTextFileParser(true, this.snpFile);
        while (parser.hasNext()) {
            String[] parts = (String[])parser.next();
            String tmp = parts[1];
            if (this.removeChrPrefix && tmp.startsWith("chr")) {
                tmp = tmp.substring(3);
            }
            String sequence = tmp;
            if (!this.getSequenceToIndex().containsKey(sequence)) continue;
            int start = Integer.parseInt(parts[2]) + 1;
            int end = Integer.parseInt(parts[3]);
            String var = parts[11];
            VariantType type = null;
            if (var.equals(snp)) {
                type = VariantType.SNP;
                end = start;
            } else if (var.equals(insertion)) {
                type = VariantType.insertion;
                end = start + 1;
            } else if (var.equals(deletion)) {
                type = VariantType.deletion;
                --start;
                ++end;
            } else {
                if (!var.equals(indel)) continue;
                type = VariantType.insertion;
                end = --start + 1;
            }
            if (!this.sequenceToSnps.containsKey(sequence)) {
                this.sequenceToSnps.put(sequence, new TreeSet());
            }
            SortedSet<KnownVariant> sequenceVars = this.sequenceToSnps.get(sequence);
            boolean validated = !parts[12].equals("unknown");
            String name = parts[4];
            String observed = parts[9];
            Float minorAlleleFrequency = Float.valueOf(Float.parseFloat(parts[13]));
            sequenceVars.add(new KnownVariant(name, this.getSequenceToIndex().get(sequence), start, end, type, validated, observed, minorAlleleFrequency));
            ++count;
            if (!var.equals(indel)) continue;
            sequenceVars.add(new KnownVariant(name, this.getSequenceToIndex().get(sequence), start, Integer.parseInt(parts[3]) + 1, VariantType.deletion, validated, observed, minorAlleleFrequency));
            ++count;
        }
        KnownVariantFileHeader header = new KnownVariantFileHeader(null, this.dictionary.getSequences(), count, this.snpFile.getAbsolutePath());
        this.kvCodec.encodeKnownVariantFileHeader(header);
        for (int i = 0; i < this.dictionary.size(); ++i) {
            String sequenceName = this.dictionary.getSequence(i).getSequenceName();
            SortedSet<KnownVariant> snps = this.sequenceToSnps.get(sequenceName);
            if (snps != null) {
                this.log.info("Writing " + snps.size() + " variants for " + sequenceName);
                for (KnownVariant knownVariant : snps) {
                    this.kvCodec.encodeKnownVariant(knownVariant);
                }
                continue;
            }
            this.log.info("No variants output for " + sequenceName);
        }
        this.log.info("Wrote " + count + " dbSnp records.");
    }

    private Map<String, Integer> getSequenceToIndex() {
        if (this.sequenceToIndex.keySet().size() == 0) {
            for (int i = 0; i < this.dictionary.size(); ++i) {
                this.sequenceToIndex.put(this.dictionary.getSequence(i).getSequenceName(), i);
            }
        }
        return this.sequenceToIndex;
    }
}

