/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.variation.KnownVariantCodec;
import java.io.File;
import java.io.StringWriter;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.StringLineReader;

public abstract class AbstractKnownVariantCodec
extends BinaryCodec
implements KnownVariantCodec {
    public AbstractKnownVariantCodec(File dbSnpFile, boolean writing) {
        super(dbSnpFile, writing);
    }

    public abstract String getCodecVersionMagicNumber();

    protected List<SAMSequenceRecord> decodeSequenceDictionary() {
        int headerTextLength = this.readInt();
        String textHeader = this.readString(headerTextLength);
        SAMFileHeader fileHeader = new SAMTextHeaderCodec().decode(new StringLineReader(textHeader), null);
        return fileHeader.getSequenceDictionary().getSequences();
    }

    protected void encodeSequenceDictionary(List<SAMSequenceRecord> dictionary) {
        SAMFileHeader fileHeader = new SAMFileHeader();
        fileHeader.setSequenceDictionary(new SAMSequenceDictionary(dictionary));
        StringWriter headerTextBuffer = new StringWriter();
        new SAMTextHeaderCodec().encode(headerTextBuffer, fileHeader);
        String headerText = headerTextBuffer.toString();
        this.writeInt(headerText.length());
        this.writeBytes(headerText.getBytes());
    }

    protected String decodeMagicNumber() {
        return this.readString(4);
    }

    protected void encodeMagicNumber() {
        this.writeString(this.getCodecVersionMagicNumber(), false, false);
    }

    protected int decodeDbSnpCount() {
        return this.readInt();
    }

    protected void encodeDbSnpCount(int count) {
        this.writeInt(count);
    }
}

