/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.util;

import edu.mit.broad.picard.util.AbstractTextFileParser;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CloseableIterator;

public class PasteParser
implements Iterable<String[][]>,
CloseableIterator<String[][]> {
    private final CloseableIterator<String[]>[] iterators;
    private boolean iterating = false;
    private String[][] next = null;

    public PasteParser(CloseableIterator<String[]> ... iterators) {
        this.iterators = iterators;
    }

    protected String[][] readNextLine() {
        String[][] result = new String[this.iterators.length][];
        boolean oneFinished = false;
        boolean oneNotFinished = false;
        for (int i = 0; i < this.iterators.length; ++i) {
            if (!this.iterators[i].hasNext()) {
                oneFinished = true;
                continue;
            }
            result[i] = (String[])this.iterators[i].next();
            oneNotFinished = true;
        }
        if (oneFinished) {
            if (oneNotFinished) {
                String files = "";
                for (CloseableIterator<String[]> failing : this.iterators) {
                    if (!(failing instanceof AbstractTextFileParser)) continue;
                    if (files.length() > 0) {
                        files = files + ", ";
                    }
                    files = files + ((AbstractTextFileParser)failing).getFileName();
                }
                throw new PicardException("Mismatched file lengths in PasteParser: " + files);
            }
            return null;
        }
        return result;
    }

    @Override
    public void close() {
        for (CloseableIterator<String[]> iterator : this.iterators) {
            iterator.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported.");
    }

    @Override
    public Iterator<String[][]> iterator() {
        if (this.iterating) {
            throw new IllegalStateException("iterator() method can only be called once, before thefirst call to hasNext()");
        }
        this.next = this.readNextLine();
        this.iterating = true;
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.iterating) {
            this.next = this.readNextLine();
            this.iterating = true;
        }
        return this.next != null;
    }

    @Override
    public String[][] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iteration has no more elements.");
        }
        String[][] result = this.next;
        this.next = this.readNextLine();
        return result;
    }
}

