/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.util;

import edu.mit.broad.picard.util.AbstractTextFileParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.RuntimeIOException;

public class BasicTextFileParser
extends AbstractTextFileParser {
    private AsciiLineReader reader;
    private final ArrayList<File> files = new ArrayList();
    String currentFileName = null;

    public BasicTextFileParser(boolean treatGroupedDelimitersAsOne, File ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("At least one file must be specified.");
        }
        this.files.addAll(Arrays.asList(files));
        File f = this.files.remove(0);
        this.currentFileName = f.getAbsolutePath();
        this.reader = new AsciiLineReader(IoUtil.openFileForReading(f));
        this.setTreatGroupedDelimitersAsOne(treatGroupedDelimitersAsOne);
    }

    public BasicTextFileParser(boolean treatGroupedDelimitersAsOne, int wordCount, File ... files) {
        this(treatGroupedDelimitersAsOne, files);
        this.setWordCount(wordCount);
    }

    @Override
    protected byte[] readNextLine() {
        try {
            String line = this.reader.readLine();
            if (line != null) {
                return line.getBytes();
            }
            if (this.files.size() > 0) {
                this.currentFileName = this.files.get(0).getAbsolutePath();
                this.reader = new AsciiLineReader(IoUtil.openFileForReading(this.files.remove(0)));
                return this.readNextLine();
            }
            return null;
        }
        catch (RuntimeIOException ioe) {
            throw new PicardException("Error reading from file " + this.currentFileName, ioe);
        }
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public String getFileName() {
        return this.currentFileName;
    }
}

