/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.genotype.geli;

import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoods;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoodsCodec;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoodsSortingCodec;
import java.io.DataOutputStream;
import java.io.File;
import net.sf.picard.util.LocusComparator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.BlockCompressedOutputStream;
import net.sf.samtools.util.SortingCollection;

public class GeliFileWriter {
    private final SAMFileHeader header;
    private SortingCollection<GenotypeLikelihoods> likelihoodsSorter;
    private GenotypeLikelihoods prevLikelihoods;
    private final LocusComparator<GenotypeLikelihoods> presortedComparator = new LocusComparator();
    private final boolean presorted;
    private GenotypeLikelihoodsCodec genotypeLikelihoodsCodec;
    private final File path;

    public static GeliFileWriter newInstanceForPresortedRecords(File path, SAMFileHeader fileHeader) {
        return new GeliFileWriter(path, fileHeader, true, null);
    }

    public static GeliFileWriter newInstance(File path, SAMFileHeader fileHeader, int maxMemoryBytes) {
        return new GeliFileWriter(path, fileHeader, false, maxMemoryBytes);
    }

    public static GeliFileWriter newInstance(File path, SAMFileHeader fileHeader) {
        return new GeliFileWriter(path, fileHeader, false, null);
    }

    protected GeliFileWriter(File path, SAMFileHeader fileHeader, boolean presorted, Integer maxMemoryBytes) {
        if (fileHeader == null) {
            throw new IllegalArgumentException("fileHeader cannot be null");
        }
        this.path = path;
        this.header = fileHeader;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        this.presorted = presorted;
        if (!presorted) {
            this.likelihoodsSorter = SortingCollection.newInstance(GenotypeLikelihoods.class, new GenotypeLikelihoodsSortingCodec(this.header), new LocusComparator(), this.calculateMaxRecordCount(maxMemoryBytes));
        } else {
            this.initCodec();
        }
    }

    private void initCodec() {
        this.genotypeLikelihoodsCodec = new GenotypeLikelihoodsCodec(new DataOutputStream(new BlockCompressedOutputStream(this.path)), this.header);
        this.genotypeLikelihoodsCodec.setOutputFileName(this.path.getAbsolutePath());
    }

    private int calculateMaxRecordCount(Integer maxMemoryBytes) {
        double bytes = maxMemoryBytes == null ? (double)Runtime.getRuntime().maxMemory() * 0.8 : maxMemoryBytes.doubleValue();
        return (int)(bytes / 150.0);
    }

    public void addGenotypeLikelihoods(GenotypeLikelihoods genotypeLikelihoods) {
        if (this.presorted) {
            this.assertPresorted(genotypeLikelihoods);
            this.genotypeLikelihoodsCodec.encode(genotypeLikelihoods);
        } else {
            this.likelihoodsSorter.add(genotypeLikelihoods);
        }
    }

    private void assertPresorted(GenotypeLikelihoods genotypeLikelihoods) {
        if (this.prevLikelihoods != null) {
            int comparison = this.presortedComparator.compare(this.prevLikelihoods, genotypeLikelihoods);
            if (comparison > 0) {
                throw new IllegalArgumentException("GenotypeLikelihoods added out of order in GELIFileWriterImpl.addGenotypeLikelihoods for " + this.genotypeLikelihoodsCodec.getOutputFileName() + ". Offending records are at [" + this.prevLikelihoods.getSequenceIndex() + ":" + this.prevLikelihoods.getPosition() + "] and [" + genotypeLikelihoods.getSequenceIndex() + ":" + genotypeLikelihoods.getPosition() + "]");
            }
            if (comparison == 0) {
                throw new IllegalArgumentException("GenotypeLikelihoods added at duplicate locus for " + this.genotypeLikelihoodsCodec.getOutputFileName() + ". Offending records are at [" + genotypeLikelihoods.getSequenceIndex() + ":" + genotypeLikelihoods.getPosition() + "]");
            }
        }
        this.prevLikelihoods = genotypeLikelihoods;
    }

    public final void close() {
        if (this.likelihoodsSorter != null) {
            this.initCodec();
            for (GenotypeLikelihoods genotypeLikelihoods : this.likelihoodsSorter) {
                this.genotypeLikelihoodsCodec.encode(genotypeLikelihoods);
            }
            this.likelihoodsSorter.cleanup();
        }
        this.genotypeLikelihoodsCodec.close();
    }

    public SAMFileHeader getFileHeader() {
        return this.header;
    }

    public File getPath() {
        return this.path;
    }
}

