/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.reflections.util.ClasspathHelper;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestAwareClasspathHelper
extends ClasspathHelper {
    public static List<URL> getUrlsForManifestCurrentClasspath() {
        List<URL> urls = ManifestAwareClasspathHelper.getUrlsForCurrentClasspath();
        ArrayList appendingURLs = Lists.newArrayList();
        for (URL url : urls) {
            ManifestAwareClasspathHelper.extractJarClasspath(appendingURLs, url.getFile());
        }
        appendingURLs.addAll(urls);
        ArrayList retURLs = Lists.newArrayList();
        for (URL u : appendingURLs) {
            boolean found = false;
            for (Vfs.DefaultUrlTypes tp : Vfs.DefaultUrlTypes.values()) {
                if (!tp.matches(u)) continue;
                found = true;
            }
            if (!found) continue;
            retURLs.add(u);
        }
        return ImmutableList.copyOf((Iterable)retURLs);
    }

    private static void extractJarClasspath(List<URL> javaClassPath, String part) {
        try {
            File jarFile = new File(part);
            JarFile myJar = new JarFile(part);
            javaClassPath.add(new JarPath(jarFile.getPath(), new File(part).getParent(), part).toValidFile().toURL());
            Attributes.Name classPath = new Attributes.Name("Class-Path");
            if (myJar.getManifest() != null && myJar.getManifest().getMainAttributes().containsKey(classPath)) {
                for (String jar : myJar.getManifest().getMainAttributes().getValue(classPath).split(" ")) {
                    JarPath pt = new JarPath(jarFile.getPath(), new File(part).getParent(), jar);
                    if (pt.toValidFile() == null) continue;
                    javaClassPath.add(pt.toValidFile().toURL());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class JarPath {
        private final String mPath;
        private final String mFilename;
        private final String mWorkingDir;

        public JarPath(String workingDir, String path, String filename) {
            this.mPath = path;
            this.mFilename = filename;
            this.mWorkingDir = workingDir;
        }

        public File toValidFile() {
            if (new File(this.mFilename).exists()) {
                return new File(this.mFilename);
            }
            if (new File(this.mPath + File.separator + this.mFilename).exists()) {
                return new File(this.mPath + File.separator + this.mFilename);
            }
            if (new File(this.mWorkingDir + File.separator + this.mFilename).exists()) {
                return new File(this.mWorkingDir + File.separator + this.mFilename);
            }
            return null;
        }

        public boolean isValid() {
            return this.toValidFile() != null;
        }
    }
}

