/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathHelper {
    public static List<URL> getUrlsForPackagePrefix(String packagePrefix) {
        try {
            Enumeration<URL> urlEnumeration = Utils.getContextClassLoader().getResources(packagePrefix.replace(".", "/"));
            ArrayList urls = Lists.newArrayList((Iterator)Iterators.forEnumeration(urlEnumeration));
            return ClasspathHelper.getBaseUrls(urls, ClasspathHelper.getUrlsForCurrentClasspath());
        }
        catch (IOException e) {
            throw new ReflectionsException("Can't resolve URL for package prefix " + packagePrefix, e);
        }
    }

    public static List<URL> getUrlsForCurrentClasspath() {
        String javaClassPath;
        ArrayList urls = Lists.newArrayList();
        for (ClassLoader loader = Utils.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            Collections.addAll(urls, ((URLClassLoader)loader).getURLs());
        }
        if (urls.isEmpty() && (javaClassPath = System.getProperty("java.class.path")) != null) {
            for (String path : javaClassPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (Exception e) {
                    throw new ReflectionsException("could not create url from " + path, e);
                }
            }
        }
        return ImmutableList.copyOf((Iterable)urls);
    }

    public static URL getUrlForClass(Class<?> aClass) {
        String resourceName = aClass.getName().replace(".", "/") + ".class";
        URL packageUrl = Utils.getContextClassLoader().getResource(resourceName);
        if (packageUrl != null) {
            return ClasspathHelper.getBaseUrl(packageUrl, ClasspathHelper.getUrlsForCurrentClasspath());
        }
        return null;
    }

    public static URL getBaseUrl(URL url, Collection<URL> baseUrls) {
        if (url != null) {
            String path1 = Vfs.normalizePath(url);
            for (URL baseUrl : baseUrls) {
                String path2 = Vfs.normalizePath(baseUrl);
                if (!path1.startsWith(path2)) continue;
                return baseUrl;
            }
        }
        return url;
    }

    public static URL getBaseUrl(URL url) {
        return ClasspathHelper.getBaseUrl(url, ClasspathHelper.getUrlsForCurrentClasspath());
    }

    public static List<URL> getBaseUrls(List<URL> urls, Collection<URL> baseUrls) {
        ArrayList result = Lists.newArrayList();
        for (URL url : urls) {
            result.add(ClasspathHelper.getBaseUrl(url, baseUrls));
        }
        return result;
    }
}

