/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.webservice.Format;
import edu.mit.broad.core.webservice.WebService;
import edu.mit.broad.core.webservice.WebServiceDAO;
import edu.mit.broad.core.webservice.WebServiceException;
import edu.mit.broad.core.webservice.WebServiceNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class WebServiceManager {
    private static final String INVOKING_USER_PARAMETER_NAME = "invoking_username";
    private static final WebServiceDAO wsDao = new WebServiceDAO();

    public WebService getWebService(String servicePath) throws WebServiceNotFoundException {
        WebService service = wsDao.findByPath(servicePath);
        if (service == null) {
            throw new WebServiceNotFoundException("No service could be located at path '" + servicePath + "'.");
        }
        return service;
    }

    public void executeWebService(String username, WebService service, Format format, Map<String, Object> parameters, OutputStream out) throws WebServiceException, IOException {
        parameters.put(INVOKING_USER_PARAMETER_NAME, username);
        service.execute(username, format, parameters, out);
    }
}

