/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.common.BroadCoreBaseDAO;
import edu.mit.broad.core.webservice.WebService;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class WebServiceDAO
extends BroadCoreBaseDAO<WebService> {
    @Override
    public WebService get(long id) {
        return (WebService)this.getSession().get(WebService.class, (Serializable)Long.valueOf(id));
    }

    public WebService findByPath(String path) {
        SQLQuery query = this.getSession().createSQLQuery("select {ws.*} from ws_web_service {ws} inner join ( select id,                     SYS_CONNECT_BY_PATH (name,'/') as path                from ws_category ws               connect by prior id = parent_id                start with parent_id is null            ) cat on {ws}.category_id = cat.id where {ws}.name = :name and cat.path = :path");
        query.addEntity("ws", WebService.class);
        int idx = path.lastIndexOf(47);
        String categoryPath = path.substring(0, idx);
        String serviceName = path.substring(idx + 1);
        query.setString("name", serviceName);
        query.setString("path", categoryPath);
        return (WebService)query.uniqueResult();
    }

    public List<String> getServiceTypes() {
        SQLQuery query = this.getSession().createSQLQuery("select distinct service_type from ws_web_service");
        return query.list();
    }

    public WebService getHydratedWebService(Long id) {
        Session session = this.getSession();
        Criteria c = session.createCriteria(WebService.class).add((Criterion)Restrictions.eq((String)"id", (Object)id)).setFetchMode("category", FetchMode.JOIN).setFetchMode("parameters", FetchMode.JOIN);
        return (WebService)c.uniqueResult();
    }

    public void evictWebService(WebService ws) {
        Session session = this.getSession();
        session.evict((Object)ws);
    }
}

