/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.BroadCoreException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;

public class WebServiceClient {
    private HttpClient client;
    String protocol;
    String host;
    int port;
    HttpMethodBase lastMethod;

    protected HttpClient getClient() {
        return this.client;
    }

    public WebServiceClient(String protocol, String host, int port, String username, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.client = new HttpClient();
        this.client.getState().setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(username, password));
        this.client.getParams().setAuthenticationPreemptive(true);
    }

    public Reader invoke(String servicePath, Map<String, Object> parameters) {
        PostMethod post = new PostMethod(this.protocol + "://" + this.host + ":" + this.port + servicePath);
        for (String name : parameters.keySet()) {
            Object valueOrValues = parameters.get(name);
            if (valueOrValues == null) {
                post.addParameter(name, "");
                continue;
            }
            if (valueOrValues instanceof Collection) {
                for (Object value : (Collection)valueOrValues) {
                    post.addParameter(name, String.valueOf(value));
                }
                continue;
            }
            if (valueOrValues.getClass().isArray()) {
                int len = Array.getLength(valueOrValues);
                for (int i = 0; i < len; ++i) {
                    post.addParameter(name, String.valueOf(Array.get(valueOrValues, i)));
                }
                continue;
            }
            post.addParameter(name, String.valueOf(valueOrValues));
        }
        post.setDoAuthentication(true);
        try {
            int status = this.client.executeMethod((HttpMethod)post);
            if (status != 200) {
                throw new BroadCoreException("Error invoking webservice on " + post.getURI() + ". Error: " + post.getResponseBodyAsString());
            }
            this.lastMethod = post;
            return new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream()));
        }
        catch (HttpException he) {
            throw new BroadCoreException("HttpException contacting web service provider.", he);
        }
        catch (IOException he) {
            throw new BroadCoreException("IOException contacting web service provider.", he);
        }
    }

    public void releaseConnection() {
        if (this.lastMethod != null) {
            this.lastMethod.releaseConnection();
        }
    }
}

