/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.common.ParameterConverter;
import edu.mit.broad.core.webservice.Format;
import edu.mit.broad.core.webservice.WebService;
import edu.mit.broad.core.webservice.WebServiceExecutionException;
import edu.mit.broad.core.webservice.WebServiceManager;
import edu.mit.broad.core.webservice.WebServiceNotFoundException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WebServiceActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(WebServiceActionBean.class);
    private ActionBeanContext context;
    private Format format;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public Resolution clearErrors() {
        if (this.getContext().getValidationErrors().get((Object)"format") != null) {
            return new ErrorResolution(400, "Unknown format specified.");
        }
        return null;
    }

    @DefaultHandler
    public Resolution service() {
        final String username = this.getInvokingUsername();
        final String pathInfo = this.getContext().getRequest().getPathInfo();
        try {
            final HttpServletRequest request = this.getContext().getRequest();
            final WebServiceManager mgr = new WebServiceManager();
            final WebService service = mgr.getWebService(pathInfo);
            if (this.format == null) {
                this.format = Format.text;
            }
            final HashMap<String, Object> params = new HashMap<String, Object>();
            ValidationErrors errors = this.getContext().getValidationErrors();
            Locale locale = this.getContext().getLocale();
            ParameterConverter converter = new ParameterConverter();
            converter.convertParameters(request.getParameterMap(), params, service.getParameters(), locale, errors);
            if (errors.size() > 0) {
                StringBuilder message = new StringBuilder();
                for (List fieldErrors : errors.values()) {
                    for (ValidationError error : fieldErrors) {
                        message.append(error.getMessage(locale)).append('\n');
                    }
                }
                return new ErrorResolution(400, message.toString());
            }
            return new StreamingResolution(this.format.getMimeType()){

                protected void stream(HttpServletResponse response) throws Exception {
                    try {
                        mgr.executeWebService(username, service, WebServiceActionBean.this.format, params, (OutputStream)response.getOutputStream());
                        response.flushBuffer();
                    }
                    catch (WebServiceExecutionException e) {
                        log.error((Object)("Error executing web service. Service: " + pathInfo + ". User: " + username + ". Parameters: " + params), (Throwable)e);
                        if (!response.isCommitted()) {
                            response.reset();
                            new ErrorResolution(500, "Error executing service: " + e.toString()).execute(request, response);
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)"IOException encountered when trying to write WebService response.", (Throwable)e);
                    }
                }
            };
        }
        catch (WebServiceNotFoundException wsnfe) {
            return new ErrorResolution(404, "No service exists at: " + pathInfo);
        }
    }

    protected String getInvokingUsername() {
        return this.getContext().getRequest().getUserPrincipal().getName();
    }

    public static class ErrorResolution
    implements Resolution {
        public static final int BAD_REQUEST = 400;
        public static final int FORBIDDEN = 403;
        public static final int INTERNAL_ERROR = 500;
        public static final int NOT_FOUND = 404;
        private int responseCode;
        private String message;

        public ErrorResolution(int responseCode, String message) {
            this.responseCode = responseCode;
            this.message = message;
        }

        public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.setStatus(this.responseCode);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            writer.write(this.message);
            writer.close();
            response.flushBuffer();
        }
    }
}

