/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.webservice.Category;
import edu.mit.broad.core.webservice.DefinedTerm;
import edu.mit.broad.core.webservice.DefinedTermDAO;
import edu.mit.broad.core.webservice.Format;
import edu.mit.broad.core.webservice.Parameter;
import edu.mit.broad.core.webservice.WebServiceException;
import edu.mit.broad.core.webservice.WebServiceExecutionException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="service_type")
@Table(name="ws_web_service")
public abstract class WebService {
    @Id
    @GeneratedValue(generator="GenWsWebService")
    @GenericGenerator(name="GenWsWebService", strategy="sequence", parameters={@org.hibernate.annotations.Parameter(name="sequence", value="sq_ws_web_service")})
    private Long id;
    private String name;
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoryId")
    private Category category;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="webServiceId", nullable=false)
    @IndexColumn(name="list_index")
    private List<Parameter> parameters;
    @Lob
    private String data;
    @Transient
    private String url;
    private static final DefinedTermDAO dtDao = new DefinedTermDAO();
    @Column(name="service_type", nullable=false, insertable=false, updatable=false)
    private String type;

    public String getType() {
        return this.type;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getServiceType() {
        return this.type;
    }

    public abstract void execute(String var1, Format var2, Map<String, Object> var3, OutputStream var4) throws WebServiceException, IOException;

    protected final void assertDefinedTerm(String term) throws WebServiceExecutionException {
        DefinedTerm t = dtDao.findByName(term);
        if (t == null) {
            throw new WebServiceExecutionException("Unknown term '" + term + "'. All parameters and " + "columns/properties must be defined terms.");
        }
    }

    public String getFullyQualifiedName() {
        if (this.getCategory().getParent() == null) {
            return "/" + this.getCategory().getName() + "/" + this.getName();
        }
        Category tmp = this.getCategory();
        String fullname = "";
        while (tmp.getParent() != null) {
            fullname = "/" + tmp.getName() + fullname;
            tmp = tmp.getParent();
        }
        fullname = "/" + tmp.getName() + fullname + "/" + this.getName();
        return fullname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !WebService.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        WebService that = (WebService)o;
        return !(this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String toString() {
        return "WebService{id=" + this.id + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", type='" + this.type + '\'' + '}';
    }
}

