/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.webservice.ColumnarDataWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;

public class TabSeparatedTextWriter
extends ColumnarDataWriter {
    private static final char TAB = '\t';
    private int currentColumn;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance();

    @Override
    public void nextRow() throws IOException {
        this.currentColumn = 0;
        this.getWriter().newLine();
    }

    @Override
    public void writeHeader() throws IOException {
        Iterator<String> iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            this.getWriter().write(iterator.next());
            if (!iterator.hasNext()) continue;
            this.getWriter().write(9);
        }
    }

    @Override
    public void writeFooter() throws IOException {
        this.getWriter().newLine();
    }

    @Override
    public void writeValue(Object value) throws IOException {
        if (this.currentColumn++ != 0) {
            this.getWriter().write(9);
        }
        if (value instanceof Date) {
            value = this.dateFormat.format((Date)value);
        } else if (value != null) {
            this.getWriter().write(String.valueOf(value));
        }
    }
}

