/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.Main;
import edu.mit.broad.core.util.DbUtils;
import edu.mit.broad.core.webservice.BaseWriter;
import edu.mit.broad.core.webservice.ColumnarDataWriter;
import edu.mit.broad.core.webservice.Format;
import edu.mit.broad.core.webservice.InvalidRequestException;
import edu.mit.broad.core.webservice.Parameter;
import edu.mit.broad.core.webservice.WebService;
import edu.mit.broad.core.webservice.WebServiceException;
import edu.mit.broad.core.webservice.WebServiceExecutionException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

@Entity
@DiscriminatorValue(value="query")
public class QueryWebService
extends WebService {
    public final String getQuery() {
        return this.getData();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(String username, Format format, Map<String, Object> parameters, OutputStream out) throws WebServiceException, IOException {
        String query = this.getQuery();
        query = query.replace("${env}", Main.getInstance().getEnvironment());
        Connection conn = null;
        OraclePreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int i;
            conn = this.getDatabaseConnection();
            OracleConnection oconn = DbUtils.getOracleConnection(conn);
            ps = (OraclePreparedStatement)oconn.prepareStatement(query);
            for (Parameter param : this.getParameters()) {
                String name = param.getTerm().getName();
                Object value = parameters.get(name);
                DbUtils.bindParameter(ps, param.getType(), name, value);
            }
            rs = ps.executeQuery();
            BaseWriter baseWriter = format.getWriterClass().newInstance();
            ColumnarDataWriter writer = null;
            if (!(baseWriter instanceof ColumnarDataWriter)) throw new InvalidRequestException("Format '" + (Object)((Object)format) + "' is not supported for this service.");
            writer = (ColumnarDataWriter)baseWriter;
            writer.setOut(out);
            ResultSetMetaData metadata = rs.getMetaData();
            int count = metadata.getColumnCount();
            for (i = 1; i <= count; ++i) {
                String label = metadata.getColumnLabel(i).toLowerCase();
                this.assertDefinedTerm(label);
                writer.addColumn(label);
            }
            writer.writeHeader();
            while (rs.next()) {
                writer.nextRow();
                for (i = 1; i <= count; ++i) {
                    writer.writeValue(rs.getObject(i));
                }
            }
            writer.writeFooter();
            writer.flush();
        }
        catch (SQLException se) {
            try {
                throw new WebServiceExecutionException("Unexpected database error executing service.", se);
                catch (InstantiationException ie) {
                    throw new WebServiceExecutionException("Could not instantiate Writer class for service.", ie);
                }
                catch (IllegalAccessException iae) {
                    throw new WebServiceExecutionException("Could not instantiate Writer class for service.", iae);
                }
            }
            catch (Throwable throwable) {
                DbUtils.close(rs, ps, conn);
                throw throwable;
            }
        }
        DbUtils.close(rs, ps, conn);
    }

    private Connection getDatabaseConnection() throws SQLException {
        return Main.getInstance().getConnection();
    }
}

