/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.util.ReflectionUtils;
import edu.mit.broad.core.webservice.Format;
import edu.mit.broad.core.webservice.Parameter;
import edu.mit.broad.core.webservice.WebService;
import edu.mit.broad.core.webservice.WebServiceException;
import edu.mit.broad.core.webservice.WebServiceExecutionException;
import edu.mit.broad.core.webservice.WebServiceImplementation;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue(value="java")
public class JavaWebService
extends WebService {
    @Override
    public void execute(String username, Format format, Map<String, Object> parameters, OutputStream out) throws WebServiceException, IOException {
        WebServiceImplementation impl = this.getServiceIntance();
        this.bind(impl, parameters);
        try {
            impl.execute(username, format, out);
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (Exception e) {
            throw new WebServiceExecutionException("Error while executing web service: " + e.getMessage(), e);
        }
    }

    protected String convertParameterName(String name) {
        StringBuilder newName = new StringBuilder(name.length());
        boolean nextCharUpper = false;
        for (char ch : name.toCharArray()) {
            if (ch == '_') {
                nextCharUpper = true;
                continue;
            }
            if (nextCharUpper) {
                newName.append(Character.toUpperCase(ch));
            } else {
                newName.append(ch);
            }
            nextCharUpper = false;
        }
        return newName.toString();
    }

    protected void bind(WebServiceImplementation impl, Map<String, Object> parameters) throws WebServiceException {
        for (Parameter p : this.getParameters()) {
            try {
                String name = p.getName();
                Object value = parameters.get(name);
                if (value == null) continue;
                String propName = this.convertParameterName(name);
                PropertyDescriptor pd = ReflectionUtils.getPropertyDescriptor(impl.getClass(), propName);
                if (pd == null) {
                    throw new WebServiceExecutionException("Service '" + this.getName() + "' does not declare a property with name '" + propName + "'.");
                }
                pd.getWriteMethod().invoke((Object)impl, value);
            }
            catch (WebServiceException wse) {
                throw wse;
            }
            catch (Exception e) {
                throw new WebServiceExecutionException("Exception invoking service '" + this.getName() + "'.");
            }
        }
    }

    protected WebServiceImplementation getServiceIntance() throws WebServiceExecutionException {
        try {
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(this.getData());
            return (WebServiceImplementation)type.newInstance();
        }
        catch (Exception e) {
            throw new WebServiceExecutionException("Could not load class '" + this.getData() + "' for service: " + this.getName());
        }
    }
}

