/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.webservice.JavaWebService;
import edu.mit.broad.core.webservice.WebServiceExecutionException;
import edu.mit.broad.core.webservice.WebServiceImplementation;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.codehaus.groovy.control.CompilationFailedException;

@Entity
@DiscriminatorValue(value="groovy")
public class GroovyWebService
extends JavaWebService {
    private static final transient GroovyClassLoader loader = new GroovyClassLoader(){
        private Map<String, String> cache = new ConcurrentHashMap<String, String>();

        public Class parseClass(String groovy, String name) throws CompilationFailedException {
            String oldSource = this.cache.get(name);
            if (oldSource == null) {
                GroovyCodeSource gcs = new GroovyCodeSource(groovy, name, "/broad/webservice");
                this.cache.put(name, groovy);
                return this.parseClass(gcs, true);
            }
            if (!oldSource.equals(groovy)) {
                Class c = (Class)this.sourceCache.remove(name);
                if (c != null) {
                    this.removeClassCacheEntry(c.getName());
                }
                GroovyCodeSource gcs = new GroovyCodeSource(groovy, name, "/broad/webservice");
                this.cache.put(name, groovy);
                return this.parseClass(gcs, true);
            }
            return (Class)this.sourceCache.get(name);
        }
    };

    @Override
    protected WebServiceImplementation getServiceIntance() throws WebServiceExecutionException {
        try {
            String name = this.getName() + "_" + this.getId() + ".groovy";
            return (WebServiceImplementation)loader.parseClass(this.getData(), name).newInstance();
        }
        catch (Exception e) {
            throw new WebServiceExecutionException("Could not load groovy class from source.", e);
        }
    }
}

