/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.webservice;

import edu.mit.broad.core.BroadCoreException;
import edu.mit.broad.core.util.ReflectionUtils;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="ws_defined_term")
public class DefinedTerm {
    @Id
    @GeneratedValue(generator="GenWsDefinedTerm")
    @GenericGenerator(name="GenWsDefinedTerm", strategy="sequence", parameters={@Parameter(name="sequence", value="sq_ws_defined_term")})
    private Long id;
    @Column(unique=true)
    private String name;
    private String description;
    @Enumerated(value=EnumType.STRING)
    private Type type;
    private String javaType;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Class getJavaClass() {
        if (this.javaType == null) {
            return null;
        }
        try {
            return ReflectionUtils.asClass(this.javaType);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BroadCoreException("Invalid DefinedTerm type: " + this.javaType, cnfe);
        }
    }

    public void setJavaClass(Class javaClass) {
        this.javaType = javaClass != null ? javaClass.getName() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !DefinedTerm.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        DefinedTerm that = (DefinedTerm)o;
        return !(this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null);
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return "DefinedTerm{name='" + this.getName() + '\'' + '}';
    }

    public static enum Type {
        STRING,
        NUMBER,
        DATE;

    }
}

