/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.WeakHashMap;

public class ReflectionUtils {
    private static final Map<Class, Map<String, PropertyDescriptor>> pdMap = new WeakHashMap<Class, Map<String, PropertyDescriptor>>();

    public static Class asClass(String className) throws ClassNotFoundException {
        if (className.endsWith("[]")) {
            className = "[L" + className.replace("[]", ";");
        }
        return Class.forName(className);
    }

    public static synchronized PropertyDescriptor getPropertyDescriptor(Class type, String property) throws IntrospectionException {
        Map<String, PropertyDescriptor> pds = pdMap.get(type);
        if (pds == null) {
            pds = new WeakHashMap<String, PropertyDescriptor>();
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                pds.put(pd.getName(), pd);
            }
            pdMap.put(type, pds);
        }
        return pds.get(property);
    }
}

