/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessController {
    private static final Log log = LogFactory.getLog(ProcessController.class);
    private static int NEXT_OUTPUT_CAPTURE_ID = 0;
    private static final String STDOUT_KEY = "stdout";
    private static final String STDERR_KEY = "stderr";
    private Map toCapture = new HashMap();
    private Map fromCapture = new HashMap();
    private OutputCapture stdoutCapture = new OutputCapture("stdout");
    private OutputCapture stderrCapture = new OutputCapture("stderr");

    public ProcessController() {
        this.stdoutCapture.start();
        this.stderrCapture.start();
    }

    public Output exec(String[] cmdarray, String stdin) {
        try {
            Process process = Runtime.getRuntime().exec(cmdarray);
            OutputStream stream = process.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
            writer.write(stdin);
            writer.flush();
            stream.close();
            return this.completeProcess(process);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception on command: " + this.join(cmdarray), e);
        }
    }

    public Output exec(String[] cmdarray) {
        try {
            return this.completeProcess(Runtime.getRuntime().exec(cmdarray));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception on command: " + this.join(cmdarray), e);
        }
    }

    public Output exec(String[] cmdarray, String[] envp, File dir) {
        try {
            return this.completeProcess(Runtime.getRuntime().exec(cmdarray, envp, dir));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception on command: " + this.join(cmdarray), e);
        }
    }

    private String join(String[] cmdarray) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < cmdarray.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(cmdarray[i]);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Output completeProcess(Process proc) {
        String stdout = null;
        String stderr = null;
        Map map = this.toCapture;
        synchronized (map) {
            this.toCapture.put(STDOUT_KEY, proc.getInputStream());
            this.toCapture.put(STDERR_KEY, proc.getErrorStream());
            this.toCapture.notifyAll();
        }
        try {
            proc.getOutputStream().close();
            proc.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Process interrupted", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close stdin", e);
        }
        finally {
            while (stdout == null || stderr == null) {
                Map map2 = this.fromCapture;
                synchronized (map2) {
                    if (this.fromCapture.containsKey(STDOUT_KEY)) {
                        stdout = (String)this.fromCapture.remove(STDOUT_KEY);
                    }
                    if (this.fromCapture.containsKey(STDERR_KEY)) {
                        stderr = (String)this.fromCapture.remove(STDERR_KEY);
                    }
                    try {
                        if (stdout == null || stderr == null) {
                            this.fromCapture.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        return new Output(proc.exitValue(), stdout, stderr);
    }

    public void close() {
        try {
            this.stdoutCapture.interrupt();
            this.stderrCapture.interrupt();
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }

    public void finalize() {
        this.close();
    }

    private class OutputCapture
    extends Thread {
        private String key;

        public OutputCapture(String key) {
            super("OutputCapture-" + key + "-" + NEXT_OUTPUT_CAPTURE_ID++);
            this.key = key;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Map map;
                String s = "";
                try {
                    Object processStream = null;
                    while (processStream == null) {
                        map = ProcessController.this.toCapture;
                        synchronized (map) {
                            if (ProcessController.this.toCapture.containsKey(this.key)) {
                                processStream = (InputStream)ProcessController.this.toCapture.remove(this.key);
                            } else {
                                ProcessController.this.toCapture.wait();
                            }
                        }
                    }
                    s = this.read((InputStream)processStream);
                    continue;
                }
                catch (InterruptedException e) {
                    log.info((Object)"OutputReader interrupted, exiting");
                }
                catch (IOException e) {
                    log.error((Object)"Error reading process output", (Throwable)e);
                    continue;
                }
                finally {
                    map = ProcessController.this.fromCapture;
                    synchronized (map) {
                        ProcessController.this.fromCapture.put(this.key, s);
                        ProcessController.this.fromCapture.notify();
                    }
                    continue;
                }
                break;
            }
        }

        private String read(InputStream processStream) throws IOException {
            int readCount;
            InputStreamReader r = new InputStreamReader(processStream);
            StringWriter w = new StringWriter();
            char[] buf = new char[4096];
            while ((readCount = r.read(buf)) >= 0) {
                ((Writer)w).write(buf, 0, readCount);
            }
            processStream.close();
            return ((Object)w).toString();
        }
    }

    public static class Output {
        public int exitValue;
        public String stdout;
        public String stderr;

        public Output(int exitValue, String stdout, String stderr) {
            this.exitValue = exitValue;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public Reader getInputReader() {
            return new StringReader(this.stdout);
        }

        public Reader getErrorReader() {
            return new StringReader(this.stderr);
        }
    }
}

