/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import edu.mit.broad.core.BroadCoreException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class JndiUtil {
    private static ConcurrentMap<String, Object> mockJndi = new ConcurrentHashMap<String, Object>();

    public static void put(String location, Object object) {
        mockJndi.put(location, object);
    }

    public static Object lookup(String location) {
        try {
            Object retval = mockJndi.get(location);
            if (retval == null) {
                InitialContext ctx = new InitialContext();
                retval = ctx.lookup(location);
            }
            return retval;
        }
        catch (NamingException ne) {
            throw new BroadCoreException("Exception looking up location '" + location + "' in JNDI.", ne);
        }
    }

    public static List<String> list(String context) {
        try {
            LinkedList<String> contents = new LinkedList<String>();
            InitialContext ctx = new InitialContext();
            NamingEnumeration<NameClassPair> list = ctx.list(context);
            while (list.hasMore()) {
                contents.add(context + "/" + list.next().getName());
            }
            return contents;
        }
        catch (NamingException ne) {
            throw new BroadCoreException("Exception while listing contents of JNDI context '" + context + "'.", ne);
        }
    }
}

