/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import edu.mit.broad.core.util.ClassFinder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Entity;
import org.hibernate.SessionFactory;
import org.hibernate.cache.HashtableCacheProvider;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.transaction.JTATransactionFactory;

public class HibernateBuilder {
    private final Properties properties = new Properties();
    private final Set<String> packages = new HashSet<String>();
    private final Set<String> hbmXmls = new HashSet<String>();

    public static Properties getDefaultProperties() {
        Properties defaults = new Properties();
        defaults.put("hibernate.dialect", Oracle9Dialect.class.getName());
        defaults.put("hibernate.cache.provider_class", HashtableCacheProvider.class.getName());
        defaults.put("hibernate.transaction.factory_class", JTATransactionFactory.class.getName());
        defaults.put("hibernate.transaction.auto_close_session", "true");
        defaults.put("hibernate.transaction.flush_before_completion", "true");
        defaults.put("hibernate.current_session_context_class", "jta");
        defaults.put("hibernate.default_batch_fetch_size", "100");
        return defaults;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setPropertyIfNull(String name, String value) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, value);
        }
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addAnnotatedPackages(String ... packages) {
        this.packages.addAll(Arrays.asList(packages));
    }

    public void addHbmXmls(String ... xmlFiles) {
        this.hbmXmls.addAll(Arrays.asList(xmlFiles));
    }

    public SessionFactory build() {
        AnnotationConfiguration config = new AnnotationConfiguration();
        config.setNamingStrategy((NamingStrategy)new ImprovedNamingStrategy());
        config.addProperties(this.properties);
        ClassFinder finder = new ClassFinder();
        for (String string : this.packages) {
            finder.find(string, Entity.class);
        }
        for (Class clazz : finder.getClasses()) {
            config.addAnnotatedClass(clazz);
        }
        for (String string : this.hbmXmls) {
            config.addResource(string);
        }
        return config.buildSessionFactory();
    }
}

