/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import edu.mit.broad.core.BroadCoreException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;

public class ExpressionUtil {
    private ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();

    public boolean isTrue(String expression, Map<String, Object> variables) {
        return this.evaluate(expression, variables, Boolean.class);
    }

    public <T> T evaluate(String expression, Map<String, Object> variables, Class<T> returnType) {
        try {
            if (!expression.startsWith("${")) {
                expression = "${" + expression;
            }
            if (!expression.endsWith("}")) {
                expression = expression + "}";
            }
            MapBasedVariableResolver vr = new MapBasedVariableResolver(variables);
            return (T)this.evaluator.evaluate(expression, returnType, (VariableResolver)vr, null);
        }
        catch (ELException ee) {
            throw new BroadCoreException("This exception is most likely caused by a improperly formed expression please double check your expression and try again.", ee);
        }
    }

    public String evaluate(String expression, Map<String, Object> variables) {
        try {
            MapBasedVariableResolver vr = new MapBasedVariableResolver(variables);
            return (String)this.evaluator.evaluate(expression, String.class, (VariableResolver)vr, null);
        }
        catch (ELException ee) {
            throw new BroadCoreException("This exception is most likely caused by a improperly formed expression please double check your expression and try again.", ee);
        }
    }

    class MapBasedVariableResolver
    implements VariableResolver {
        private Map<String, Object> variables;

        public MapBasedVariableResolver(Map<String, Object> variables) {
            this.variables = variables != null ? variables : Collections.emptyMap();
        }

        public Object resolveVariable(String name) throws ELException {
            return this.variables.get(name);
        }
    }
}

