/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import edu.mit.broad.core.BroadCoreException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class DbUtils {
    private static final Method JBOSS_METHOD;
    private static final Method TOMCAT_METHOD;
    private static final Method DBCP_METHOD;

    public static OracleConnection getOracleConnection(Connection conn) throws SQLException {
        Connection oracleConnection = null;
        try {
            if (conn instanceof OracleConnection) {
                oracleConnection = conn;
            } else if (JBOSS_METHOD != null && JBOSS_METHOD.getDeclaringClass().isAssignableFrom(conn.getClass())) {
                oracleConnection = (Connection)JBOSS_METHOD.invoke((Object)conn, new Object[0]);
            } else if (DBCP_METHOD != null && DBCP_METHOD.getDeclaringClass().isAssignableFrom(conn.getClass())) {
                oracleConnection = (Connection)DBCP_METHOD.invoke((Object)conn, new Object[0]);
            } else if (TOMCAT_METHOD != null && TOMCAT_METHOD.getDeclaringClass().isAssignableFrom(conn.getClass())) {
                oracleConnection = (Connection)TOMCAT_METHOD.invoke((Object)conn, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new BroadCoreException("Exception while attempting to unwrap connection.", e);
        }
        if (oracleConnection == null) {
            throw new SQLException("Don't know how to turn a " + conn.getClass() + " into an OracleConnection.");
        }
        return (OracleConnection)oracleConnection;
    }

    public static void bindParameter(OraclePreparedStatement ps, Class javaType, String name, Object value) throws SQLException {
        if (value instanceof Date) {
            value = new Timestamp(((Date)value).getTime());
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                ps.setArrayAtName(name, (Array)DbUtils.createArray(ps.getConnection(), value));
            } else {
                ps.setObjectAtName(name, value);
            }
        } else if (javaType != null && Date.class.isAssignableFrom(javaType)) {
            ps.setNullAtName(name, 91);
        } else {
            ps.setObjectAtName(name, null);
        }
    }

    public static ARRAY createArray(Connection conn, Object array) throws SQLException {
        ArrayDescriptor descriptor;
        conn = DbUtils.getOracleConnection(conn);
        if (Number.class.isAssignableFrom(array.getClass().getComponentType())) {
            descriptor = ArrayDescriptor.createDescriptor((String)"GAP_NUM_TABLE", (Connection)conn);
        } else if (String.class.isAssignableFrom(array.getClass().getComponentType())) {
            descriptor = ArrayDescriptor.createDescriptor((String)"GAP_VCHAR_TABLE", (Connection)conn);
        } else {
            throw new BroadCoreException("Unable to determine array type of " + array.toString());
        }
        return new ARRAY(descriptor, conn, array);
    }

    public static void close(Object ... jdbcObjects) {
        for (Object object : jdbcObjects) {
            if (object == null) continue;
            if (object instanceof ResultSet) {
                try {
                    ((ResultSet)object).close();
                }
                catch (Exception e) {}
                continue;
            }
            if (object instanceof Statement) {
                try {
                    ((Statement)object).close();
                }
                catch (Exception e) {}
                continue;
            }
            if (object instanceof Connection) {
                try {
                    ((Connection)object).close();
                }
                catch (Exception e) {}
                continue;
            }
            throw new BroadCoreException("I don't know how to close a " + object.getClass());
        }
    }

    public static DataSource makeProxiedDataSource(String jdbcUrl) throws SQLException {
        final OracleDataSource ods = new OracleDataSource();
        ods.setURL(jdbcUrl);
        return (DataSource)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DataSource.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
                Object retval = method.invoke((Object)ods, parameters);
                if (retval instanceof Connection) {
                    ((Connection)retval).setAutoCommit(false);
                }
                return retval;
            }
        });
    }

    static {
        Class<?> clazz;
        Method m = null;
        try {
            clazz = Class.forName("org.jboss.resource.adapter.jdbc.WrappedConnection");
            m = clazz.getMethod("getUnderlyingConnection", new Class[0]);
        }
        catch (Throwable t) {
            // empty catch block
        }
        JBOSS_METHOD = m;
        m = null;
        try {
            clazz = Class.forName("org.apache.commons.dbcp.PoolableConnection");
            m = clazz.getMethod("getInnermostDelegate", new Class[0]);
        }
        catch (Throwable t) {
            // empty catch block
        }
        DBCP_METHOD = m;
        m = null;
        try {
            clazz = Class.forName("org.apache.tomcat.dbcp.dbcp.DelegatingConnection");
            m = clazz.getMethod("getInnermostDelegate", new Class[0]);
            m.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TOMCAT_METHOD = m;
    }
}

