/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassFinder {
    private static final Log log = LogFactory.getLog(ClassFinder.class);
    private Set<Class<?>> classes = new HashSet();
    private Class<? extends Annotation> annotation;

    public String toClassName(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    public void find(String packageName, Class<? extends Annotation> annotation) {
        Enumeration<URL> urls;
        this.annotation = annotation;
        packageName = packageName.replace('.', '/');
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            urls = loader.getResources(packageName);
        }
        catch (IOException ioe) {
            log.warn((Object)("Could not read package: " + packageName), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath = urls.nextElement().getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                log.info((Object)("Looking for classes in location: " + urlPath));
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.scanDir(file, packageName);
                    continue;
                }
                this.scanJar(file, packageName);
            }
            catch (IOException ioe) {
                log.warn((Object)"could not read entries", (Throwable)ioe);
            }
        }
    }

    protected void scanJar(File file, String packagePath) throws ZipException, IOException {
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packagePath)) continue;
            this.handleItem(name);
        }
    }

    protected void scanDir(File file, String path) {
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.scanDir(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }

    protected void handleItem(String name) {
        if (name.endsWith(".class")) {
            String classname = this.toClassName(name);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> type = loader.loadClass(classname);
                if (type.isAnnotationPresent(this.annotation)) {
                    this.classes.add(type);
                }
            }
            catch (Throwable t) {
                log.debug((Object)("could not load class: " + classname), t);
            }
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }
}

