/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.lsf;

import edu.mit.broad.core.Main;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

abstract class TransactedRunnable
implements Runnable {
    private static final Log log = LogFactory.getLog(TransactedRunnable.class);

    TransactedRunnable() {
    }

    @Override
    public final void run() {
        Transaction tx = null;
        Session session = null;
        try {
            try {
                tx = Main.getInstance().getHibernateSession().beginTransaction();
            }
            catch (HibernateException he) {
                session = Main.getInstance().getHibernateSessionFactory().openSession();
                tx = session.beginTransaction();
                session.close();
            }
            this.runInTransaction();
            tx.commit();
        }
        catch (Throwable t) {
            log.error((Object)"Exception running transacted code.", t);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Throwable t2) {
                log.fatal((Object)"Error while attempting to rollback transaction.", t2);
            }
        }
    }

    public abstract void runInTransaction() throws Exception;
}

