/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.lsf;

import edu.mit.broad.core.Main;
import edu.mit.broad.core.lsf.LocalLsfJob;
import edu.mit.broad.core.lsf.LsfJob;
import edu.mit.broad.core.lsf.LsfJobDAO;
import edu.mit.broad.core.lsf.TransactedRunnable;
import edu.mit.broad.core.util.FileUtil;
import edu.mit.broad.core.util.ProcessController;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LsfWrapper {
    private static int CLEANUP_POLLING_SKIP_CYCLE = 100;
    private static int CLEANUP_ITERATION;
    private static long CLEANUP_EXPIRATION_TIME;
    private static String SERVER_ID;
    public static final Collection<String> CHECK_STATUSES;
    private static Log log;
    private static ScheduledExecutorService scheduledExecutor;
    private static ExecutorService callbackExecutor;
    private static final LsfJobDAO dao;

    public void performTasks() {
        this.checkJobs();
        this.checkCleanup();
    }

    public void checkJobs() {
        log.trace((Object)"Polling for LSF Job status");
        LsfJobDAO lsfDAO = dao;
        List<LsfJob> jobs = lsfDAO.findJobsByStatus(this.getServerId(), CHECK_STATUSES);
        log.debug((Object)("Found " + jobs.size() + " active LSF jobs, checking status now"));
        HashMap<String, LocalLsfJob> jobsByLsfId = new HashMap<String, LocalLsfJob>();
        for (final LsfJob job : jobs) {
            jobsByLsfId.put(job.getLsfJobId(), this.convert(job));
        }
        try {
            if (jobs.size() > 0) {
                LocalLsfJob.updateStatus(jobsByLsfId.values());
            }
            for (final LsfJob job : jobs) {
                LocalLsfJob localJob = (LocalLsfJob)jobsByLsfId.get(job.getLsfJobId());
                String lsfStatusCode = localJob.getLsfStatusCode();
                log.debug((Object)("LSF Job with LSF Job ID " + job.getLsfJobId() + " is in status " + lsfStatusCode));
                if ("DONE".equals(lsfStatusCode) || "EXIT".equals(lsfStatusCode)) {
                    String stdout = null;
                    String stderr = null;
                    try {
                        stdout = FileUtil.readFile(localJob.getOutputFile(), FileUtil.FIVE_MB);
                        stderr = FileUtil.readFile(localJob.getErrFile(), FileUtil.FIVE_MB);
                    }
                    catch (FileNotFoundException ffne) {
                        continue;
                    }
                    if (stdout == null || stdout.length() <= 0) continue;
                    job.setStandardOutput(stdout);
                    job.setErrorOutput(stderr);
                    job.setStatus(lsfStatusCode);
                    job.setUpdatedDate(new Date());
                    lsfDAO.flushToDatabase(job);
                    Future<?> future = callbackExecutor.submit(new TransactedRunnable(){

                        @Override
                        public void runInTransaction() {
                            try {
                                new LsfWrapper().doCallback(job);
                            }
                            catch (Exception e) {
                                log.error((Object)("Error executing call back notification for LSF Job ID " + job.getLsfJobId()), (Throwable)e);
                            }
                        }
                    });
                    continue;
                }
                if (!LocalLsfJob.LSF_MISSING.equals(localJob.getStatus())) continue;
                log.info((Object)("LSF Job " + localJob.getBsubJobId() + " is no longer tracked by LSF " + "and does not have an output file either. Marking as lost."));
                job.setStatus("UNKWN");
                job.setUpdatedDate(new Date());
                lsfDAO.flushToDatabase(job);
            }
        }
        catch (Throwable t) {
            log.fatal((Object)"Exception caught while updating status information for LSF Jobs. If this continues on future timeouts no LSF jobs will be processed! This needs to be remedied immediatley.", t);
        }
    }

    public void checkCleanup() {
        if (CLEANUP_ITERATION++ == CLEANUP_POLLING_SKIP_CYCLE) {
            log.trace((Object)"Checking for old completed LSF jobs to remove their LSF job ID");
            LsfJobDAO lsfDAO = dao;
            int removeCount = lsfDAO.removeLsfJobIds(CLEANUP_EXPIRATION_TIME, "DONE");
            if (removeCount > 0) {
                log.info((Object)("There were " + removeCount + " expired jobs with status " + "DONE" + " that had LSF job id removed"));
            }
            CLEANUP_ITERATION = 0;
        }
    }

    public boolean start(int timeout) {
        if (!LsfWrapper.platformSupportsLSF()) {
            log.info((Object)"Not starting LSF timer bean because platform does not support LSF.");
            return false;
        }
        TransactedRunnable task = new TransactedRunnable(){

            @Override
            public void runInTransaction() {
                new LsfWrapper().performTasks();
            }
        };
        scheduledExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "LsfJobStatusChecker");
            }
        });
        log.info((Object)("Initializing LSF polling thread with timeout interval: " + timeout + " seconds."));
        scheduledExecutor.scheduleWithFixedDelay(task, timeout, timeout, TimeUnit.SECONDS);
        callbackExecutor = new ThreadPoolExecutor(1, 3, 3600L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "LsfCallbackProcesser");
            }
        });
        return true;
    }

    public void stop() {
        try {
            scheduledExecutor.shutdown();
            callbackExecutor.shutdown();
            if (!callbackExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                callbackExecutor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public void doCallback(LsfJob job) throws Exception {
        String className = job.getCompletionListenerName();
        if (className != null) {
            Class<?> clazz = Class.forName(className);
            LsfJob.JobCompletionListener listener = (LsfJob.JobCompletionListener)clazz.newInstance();
            listener.jobCompleted(job);
        }
    }

    public LsfJob getLsfJob(long internalJobId) {
        return (LsfJob)dao.get(internalJobId);
    }

    public List<LsfJob> getLsfJobs(List<Long> internalJobIds) {
        return dao.findJobsById(internalJobIds);
    }

    public LsfJob dispatchLsfJob(LsfJob job) {
        job.setGapServerId(this.getServerId());
        int location = job.getCommand().indexOf(10);
        log.debug((Object)("Dispatching job: " + (location > 0 ? job.getCommand().substring(0, location) : job.getCommand())));
        this.dispatchUsingExec(job);
        dao.save(job);
        return job;
    }

    private void dispatchUsingExec(LsfJob job) {
        LocalLsfJob localJob = this.convert(job);
        localJob.start();
        job.setLsfJobId(localJob.getBsubJobId());
        job.setStatus(localJob.getLsfStatusCode());
        job.setUpdatedDate(new Date());
    }

    private LocalLsfJob convert(LsfJob job) {
        LocalLsfJob localJob = new LocalLsfJob();
        localJob.setCommand(job.getCommand());
        localJob.setName(job.getName());
        localJob.setQueue(job.getQueue());
        localJob.setProject(job.getProject());
        localJob.setExtraBsubArgs(job.getExtraBsubArgs());
        if (job.getWorkingDirectory() != null) {
            localJob.setWorkingDir(new File(job.getWorkingDirectory()));
        }
        if (job.getInputFilename() != null) {
            localJob.setInputFile(this.getAbsoluteFile(job.getWorkingDirectory(), job.getInputFilename()));
        }
        if (job.getOutputFilename() != null) {
            localJob.setOutputFile(this.getAbsoluteFile(job.getWorkingDirectory(), job.getOutputFilename()));
        }
        if (job.getErrorFileName() != null) {
            localJob.setErrFile(this.getAbsoluteFile(job.getWorkingDirectory(), job.getErrorFileName()));
        }
        if (job.getLsfJobId() != null) {
            localJob.setBsubJobId(job.getLsfJobId());
        }
        if (job.getStatus() != null) {
            localJob.setLsfStatusCode(job.getStatus());
        }
        return localJob;
    }

    private File getAbsoluteFile(String dir, String filename) {
        if (filename.startsWith(File.separator)) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    private String getServerId() {
        if (SERVER_ID == null) {
            String hostname = null;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
                if (hostname.indexOf(46) > 0) {
                    hostname = hostname.substring(0, hostname.indexOf(46));
                }
            }
            catch (UnknownHostException uhe) {
                hostname = "unknown_host";
            }
            SERVER_ID = Main.getInstance().getEnvironment() + ":" + hostname + ":" + System.getProperty("jboss.server.name");
        }
        return SERVER_ID;
    }

    private static boolean platformSupportsLSF() {
        ProcessController pc = new ProcessController();
        String[] cmdarray = new String[]{"bsub", "-V"};
        ProcessController.Output output = null;
        try {
            output = pc.exec(cmdarray);
        }
        catch (Exception e) {
            log.warn((Object)"Exception ignored when trying to run 'which bsub'.", (Throwable)e);
            return false;
        }
        return output.exitValue == 0;
    }

    static {
        CLEANUP_EXPIRATION_TIME = 1209600000L;
        SERVER_ID = null;
        log = LogFactory.getLog(LsfWrapper.class);
        dao = new LsfJobDAO();
        LinkedList<String> list = new LinkedList<String>();
        list.add("PEND");
        list.add("RUN");
        list.add("PSUSP");
        list.add("SSUSP");
        list.add("USUSP");
        list.add("WAIT");
        list.add("ZOMBI");
        CLEANUP_ITERATION = 0;
        CHECK_STATUSES = Collections.unmodifiableList(list);
    }
}

