/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.lsf;

import edu.mit.broad.core.common.BroadCoreBaseDAO;
import edu.mit.broad.core.lsf.LsfJob;
import edu.mit.broad.core.util.CollectionUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Restrictions;

public class LsfJobDAO
extends BroadCoreBaseDAO<LsfJob> {
    public List<LsfJob> findJobsByStatus(String serverId, Collection<String> statuses) {
        return this.findByCriteria(new Criterion[]{Restrictions.in((String)"status", statuses), Restrictions.eq((String)"gapServerId", (Object)serverId)});
    }

    void flushToDatabase(LsfJob persistentEntity) {
        this.saveOrUpdate(persistentEntity);
        this.getSession().flush();
    }

    protected List<LsfJob> findJobsById(List<Long> jobIds) {
        ArrayList<LsfJob> lsfJobs = new ArrayList<LsfJob>();
        Session session = this.getSession();
        session.setFlushMode(FlushMode.NEVER);
        Collection<Collection<Long>> jobBatchIds = CollectionUtility.split(jobIds, 1000);
        List batchResult = null;
        for (Collection<Long> jobBatch : jobBatchIds) {
            batchResult = session.createCriteria(LsfJob.class).add(Expression.in((String)"internalJobId", jobBatch)).list();
            lsfJobs.addAll(batchResult);
        }
        session.setFlushMode(FlushMode.AUTO);
        return lsfJobs;
    }

    public int removeLsfJobIds(Long expiration, String status) {
        if (expiration == null) {
            return 0;
        }
        Session session = this.getSession();
        Date expirationDate = new Date(System.currentTimeMillis() - expiration);
        String sql = "update job_lsf set lsf_job_id = null  where lsf_job_id is not null   and lsf_job_status = :status    and updated_date < :expirationDate ";
        int updatedCount = session.createSQLQuery(sql).setString("status", status).setDate("expirationDate", expirationDate).executeUpdate();
        return updatedCount;
    }
}

