/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.lsf;

import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="JOB_LSF")
public class LsfJob {
    public static final String LSF_STATUS_PENDING = "PEND";
    public static final String LSF_STATUS_SUSPENDED_P = "PSUSP";
    public static final String LSF_STATUS_SUSPENDED_U = "USUSP";
    public static final String LSF_STATUS_SUSPENDED_S = "SSUSP";
    public static final String LSF_STATUS_RUNNING = "RUN";
    public static final String LSF_STATUS_WAITING = "WAIT";
    public static final String LSF_STATUS_DONE = "DONE";
    public static final String LSF_STATUS_EXIT = "EXIT";
    public static final String LSF_STATUS_ZOMBIE = "ZOMBI";
    public static final String LSF_STATUS_UNKNOWN = "UNKWN";
    @Id
    @GeneratedValue(generator="GenJobLSF")
    @GenericGenerator(name="GenJobLSF", strategy="sequence", parameters={@Parameter(name="sequence", value="SQ_LSF_JOB")})
    @Column(name="INTERNAL_JOB_ID", unique=true, nullable=false, insertable=true, updatable=true, precision=22, scale=0)
    private Long internalJobId;
    @Lob
    private String command;
    private String workingDirectory;
    private String inputFilename;
    private String outputFilename;
    @Column(name="ERROR_FILENAME")
    private String errorFileName;
    @Column(name="JOB_NAME")
    private String name;
    private String queue;
    private String project;
    @Column(name="LSF_JOB_STATUS")
    private String status;
    private String lsfJobId;
    @Lob
    private String standardOutput;
    @Lob
    private String errorOutput;
    @Column(name="LISTENER_CLASS_NAME")
    private String completionListenerName;
    @Column(name="GAP_SERVER_ID")
    private String gapServerId;
    @Column(name="UPDATED_DATE")
    private Date updatedDate;
    @Transient
    private List<String> extraBsubArgs;

    public Long getInternalJobId() {
        return this.internalJobId;
    }

    public void setInternalJobId(Long internalJobId) {
        this.internalJobId = internalJobId;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public void setInputFilename(String inputFilename) {
        this.inputFilename = inputFilename;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public String getErrorFileName() {
        return this.errorFileName;
    }

    public void setErrorFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLsfJobId() {
        return this.lsfJobId;
    }

    public void setLsfJobId(String lsfJobId) {
        this.lsfJobId = lsfJobId;
    }

    public String getStandardOutput() {
        return this.standardOutput;
    }

    public void setStandardOutput(String standardOutput) {
        this.standardOutput = standardOutput;
    }

    public String getErrorOutput() {
        return this.errorOutput;
    }

    public void setErrorOutput(String errorOutput) {
        this.errorOutput = errorOutput;
    }

    public String getCompletionListenerName() {
        return this.completionListenerName;
    }

    public void setCompletionListenerName(String completionListenerName) {
        this.completionListenerName = completionListenerName;
    }

    public String getGapServerId() {
        return this.gapServerId;
    }

    public void setGapServerId(String gapServerId) {
        this.gapServerId = gapServerId;
    }

    public List<String> getExtraBsubArgs() {
        return this.extraBsubArgs;
    }

    public void setExtraBsubArgs(List<String> extraBsubArgs) {
        this.extraBsubArgs = extraBsubArgs;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public String toString() {
        return "LsfJob{internalJobId=" + this.internalJobId + ", command='" + this.command + '\'' + ", workingDirectory='" + this.workingDirectory + '\'' + ", inputFilename='" + this.inputFilename + '\'' + ", outputFilename='" + this.outputFilename + '\'' + ", errorFileName='" + this.errorFileName + '\'' + ", name='" + this.name + '\'' + ", queue='" + this.queue + '\'' + ", project='" + this.project + '\'' + ", status='" + this.status + '\'' + ", dateUpdated='" + this.updatedDate.toString() + "', lsfJobId='" + this.lsfJobId + '\'' + ", standardOutput='" + this.standardOutput + '\'' + ", errorOutput='" + this.errorOutput + '\'' + ", completionListenerName='" + this.completionListenerName + '\'' + ", extraBsubArgs='" + this.extraBsubArgs + "'}";
    }

    public static interface JobCompletionListener {
        public void jobCompleted(LsfJob var1) throws Exception;
    }
}

