/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.lsf;

import edu.mit.broad.core.BroadCoreException;
import edu.mit.broad.core.lsf.LocalLsfJobProperties;
import edu.mit.broad.core.lsf.LocalLsfJobStatus;
import edu.mit.broad.core.util.FileUtil;
import edu.mit.broad.core.util.ProcessController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalLsfJob {
    public static final LocalLsfJobStatus INITIAL = new LocalLsfJobStatus("inital");
    public static final LocalLsfJobStatus ACTIVE = new LocalLsfJobStatus("active");
    public static final LocalLsfJobStatus PENDING = ACTIVE.newSubstatus("pending");
    public static final LocalLsfJobStatus SUBMITTED = PENDING.newSubstatus("submittedToLSF");
    public static final LocalLsfJobStatus LSF_PENDING = PENDING.newSubstatus("pendingInLSF");
    public static final LocalLsfJobStatus LSF_WAIT = PENDING.newSubstatus("waitingInLSF");
    public static final LocalLsfJobStatus RUNNING = ACTIVE.newSubstatus("running");
    public static final LocalLsfJobStatus SUSPENDED = RUNNING.newSubstatus("suspendedInLSF");
    public static final LocalLsfJobStatus WAITING_FOR_CHILDREN = RUNNING.newSubstatus("waitingForChildren");
    public static final LocalLsfJobStatus FINAL = new LocalLsfJobStatus("final");
    public static final LocalLsfJobStatus DONE = FINAL.newSubstatus("success");
    public static final LocalLsfJobStatus FAILED = FINAL.newSubstatus("failed");
    public static final LocalLsfJobStatus LSF_EXIT = FAILED.newSubstatus("exitInLSF");
    public static final LocalLsfJobStatus LSF_SIGNALED = FAILED.newSubstatus("signaled");
    public static final LocalLsfJobStatus LSF_MISSING = FAILED.newSubstatus("missingFromLSF");
    public static final LocalLsfJobStatus LSF_ZOMBIE = FAILED.newSubstatus("zombieInLSF");
    public static final LocalLsfJobStatus LSF_UNKNOWN = RUNNING.newSubstatus("unknownStatusInLSF");
    public static final LocalLsfJobStatus EXITED_UNKNOWN = FINAL.newSubstatus("exitedWithoutStatus");
    public static final LocalLsfJobStatus REMOVED = FINAL.newSubstatus("removedBeforeLSF");
    public static final LocalLsfJobStatus FAILED_SIBLING = FAILED.newSubstatus("siblingFailed");
    private static final Log log = LogFactory.getLog(LocalLsfJob.class);
    private static final Pattern JOB_ID = Pattern.compile("\\d+");
    private static final Pattern cpuTimePattern = Pattern.compile("\\s*CPU time\\s+:\\s+(\\d+)(?:\\.\\d+)?\\s+sec\\.\\s*");
    private static final Pattern maxMemoryPattern = Pattern.compile("\\s*Max Memory\\s+:\\s+(\\d+)\\s+MB\\s*");
    private static final Pattern maxSwapPattern = Pattern.compile("\\s*Max Swap\\s+:\\s+(\\d+)\\s+MB\\s*");
    private static final Map<String, LocalLsfJobStatus> lsfStatusMap = new HashMap<String, LocalLsfJobStatus>();
    private LocalLsfJobProperties properties = new LocalLsfJobProperties();
    private LocalLsfJobStatus status = INITIAL;
    private static ThreadLocal processController;

    protected void setStatus(LocalLsfJobStatus status) {
        this.status = status;
    }

    public LocalLsfJobStatus getStatus() {
        return this.status;
    }

    public void start() {
        LocalLsfJob.check(this.status == INITIAL, "Start was called on a job that wasn't in INITIAL status.", this);
        LocalLsfJob.check(this.properties.getCommand() != null, "Command was not set on LocalLsfJob", this);
        LocalLsfJob.check(this.properties.getWorkingDir() != null, "Working directory must be set on LocalLsfJob", this);
        LocalLsfJob.check(this.properties.getOutputFile() != null, "Output file must be set on LocalLsfJob", this);
        ProcessController.Output bsubOutput = null;
        BufferedReader stdoutReader = null;
        BufferedReader stderrReader = null;
        try {
            List<String> args = this.getBsubCommand();
            String[] argArray = args.toArray(new String[0]);
            String[] envps = this.getEnvironmentVariables();
            bsubOutput = ((ProcessController)processController.get()).exec(argArray, envps, this.properties.getWorkingDir());
            stdoutReader = new BufferedReader(bsubOutput.getInputReader());
            stderrReader = new BufferedReader(bsubOutput.getErrorReader());
            if (bsubOutput.exitValue != 0) {
                throw new Exception("Failed to submit LSF job, got exit code " + bsubOutput.exitValue + ". Standard error contained: " + FileUtil.readReader(stderrReader, FileUtil.FIVE_MB));
            }
            Matcher matcher = JOB_ID.matcher(stdoutReader.readLine());
            matcher.find();
            this.properties.setBsubJobId(matcher.group());
            if (this.getName() == null) {
                this.properties.setName("lsf_job_" + this.properties.getBsubJobId());
            }
        }
        catch (Exception ex) {
            throw new BroadCoreException("Exception submitting LSF job.", ex);
        }
        this.setStatus(LSF_PENDING);
    }

    public List<String> getBsubCommand() {
        String project;
        File inputFile;
        ArrayList<String> args = new ArrayList<String>();
        args.add("bsub");
        String name = this.properties.getName();
        if (name != null) {
            args.add("-J");
            args.add(name);
        }
        if ((inputFile = this.properties.getInputFile()) != null) {
            args.add("-i");
            args.add(inputFile.getAbsolutePath());
        }
        args.add("-o");
        args.add(this.properties.getOutputFile().getAbsolutePath());
        args.add("-e");
        args.add(this.properties.getErrFile().getAbsolutePath());
        String queue = this.properties.getQueue();
        if (queue != null) {
            args.add("-q");
            args.add(queue);
        }
        if ((project = this.properties.getProject()) != null) {
            args.add("-P");
            args.add(project);
        }
        if (this.properties.getExtraBsubArgs() != null) {
            args.addAll(this.properties.getExtraBsubArgs());
        }
        args.add(this.properties.getCommand());
        return args;
    }

    private String[] getEnvironmentVariables() {
        Map<String, String> variables = System.getenv();
        Set<String> variableNames = variables.keySet();
        ArrayList<String> envs = new ArrayList<String>();
        boolean i = false;
        for (String key : variableNames) {
            String value = variables.get(key);
            if (key.equalsIgnoreCase("LD_ASSUME_KERNEL") || value == null) continue;
            envs.add(key + "=" + value);
        }
        return envs.toArray(new String[0]);
    }

    public LocalLsfJobStatus updateStatus() {
        LocalLsfJob.updateStatus(Collections.singletonList(this));
        return this.status;
    }

    public void cancel(boolean waitForExit) throws InterruptedException {
        LocalLsfJob.cancel(Collections.singletonList(this));
        while (waitForExit && this.status.isInstance(ACTIVE)) {
            Thread.sleep(3000L);
            this.updateStatus();
        }
    }

    public String getRunningOutput() {
        String[] cmdarray = new String[]{"bpeek", this.getBsubJobId()};
        ProcessController.Output bpeekOutput = ((ProcessController)processController.get()).exec(cmdarray, null, this.properties.getWorkingDir());
        return bpeekOutput.stderr + bpeekOutput.stdout;
    }

    public void suspend() throws InterruptedException {
        String[] cmdarray = new String[]{"bstop", this.getBsubJobId()};
        ProcessController.Output bstopOutput = ((ProcessController)processController.get()).exec(cmdarray, null, this.properties.getWorkingDir());
        LocalLsfJob.check(this.isEmpty(bstopOutput.stderr), "bstop returned stderr: " + bstopOutput.stderr);
        LocalLsfJob.check(bstopOutput.stdout.equals("Job <" + this.getBsubJobId() + "> is being stopped\n"), "bstop returned stdout:" + bstopOutput.stdout);
        this.updateStatus();
    }

    public void resume() throws InterruptedException {
        String[] cmdarray = new String[]{"bresume", this.getBsubJobId()};
        ProcessController.Output bOutput = ((ProcessController)processController.get()).exec(cmdarray, null, this.properties.getWorkingDir());
        LocalLsfJob.check(this.isEmpty(bOutput.stderr), "bresume returned stderr: " + bOutput.stderr);
        LocalLsfJob.check(bOutput.stdout.matches("Job <" + this.getBsubJobId() + "> is being resumed\n"), "bresume returned stdout: " + bOutput.stdout);
        this.updateStatus();
    }

    public static void cancel(Collection jobs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("bkill");
        for (LocalLsfJob job : jobs) {
            if (!job.getStatus().isInstance(ACTIVE)) continue;
            args.add(job.getBsubJobId());
        }
        if (args.size() == 1) {
            log.info((Object)"cancel called with no active jobs");
            return;
        }
        String[] cmdarray = args.toArray(new String[args.size()]);
        ((ProcessController)processController.get()).exec(cmdarray);
    }

    public static void updateStatus(Collection<LocalLsfJob> jobs) {
        ArrayList<String> args = new ArrayList<String>();
        HashMap<Integer, LocalLsfJob> jobMap = new HashMap<Integer, LocalLsfJob>();
        args.add("bjobs");
        for (LocalLsfJob job : jobs) {
            LocalLsfJob.check(job.status.isInstance(ACTIVE) || job.status.isInstance(FINAL), new Object[0]);
            if (!job.status.isInstance(ACTIVE)) continue;
            args.add(job.getBsubJobId());
            jobMap.put(new Integer(job.getBsubJobId()), job);
        }
        if (jobMap.size() == 0) {
            log.info((Object)"updateStatus called with no active jobs");
            return;
        }
        ProcessController.Output bjobsOutput = null;
        BufferedReader stdoutReader = null;
        BufferedReader stderrReader = null;
        try {
            LocalLsfJobStatus status;
            LocalLsfJob job;
            Integer bsubJobId;
            String line;
            String[] cmdarray = args.toArray(new String[args.size()]);
            bjobsOutput = ((ProcessController)processController.get()).exec(cmdarray);
            stdoutReader = new BufferedReader(bjobsOutput.getInputReader());
            stderrReader = new BufferedReader(bjobsOutput.getErrorReader());
            while ((line = stderrReader.readLine()) != null) {
                int start = line.indexOf("<");
                int end = line.indexOf(">");
                if (start == -1 || end == -1) {
                    log.warn((Object)("bsub stderr line without < or >: " + line));
                    continue;
                }
                bsubJobId = new Integer(line.substring(start + 1, end));
                job = (LocalLsfJob)jobMap.get(bsubJobId);
                status = LocalLsfJob.readStatusFromFile(job);
                if (status == null) {
                    job.setStatus(LSF_MISSING);
                } else {
                    job.setStatus(status);
                }
                jobMap.remove(bsubJobId);
            }
            String firstLine = stdoutReader.readLine();
            if (firstLine != null) {
                String line2;
                while ((line2 = stdoutReader.readLine()) != null) {
                    if (!Pattern.matches("^\\d+.*", line2)) continue;
                    String[] fields = line2.split("\\s+");
                    bsubJobId = new Integer(fields[0]);
                    job = (LocalLsfJob)jobMap.get(bsubJobId);
                    status = lsfStatusMap.get(fields[2]);
                    if (status == null) {
                        throw new Exception("Unknown status for job " + job.getBsubJobId() + ": " + fields[2]);
                    }
                    job.setStatus(status);
                    jobMap.remove(bsubJobId);
                }
            }
            LocalLsfJob.check(jobMap.size() == 0, "Not all jobs were returned from bsub", jobMap);
        }
        catch (Exception e) {
            throw new BroadCoreException("Error updating LocalLsfJob status: ", e);
        }
        finally {
            try {
                stdoutReader.close();
            }
            catch (Exception e1) {}
            try {
                stderrReader.close();
            }
            catch (Exception e) {}
        }
    }

    public File getErrFile() {
        return this.properties.getErrFile();
    }

    public File getInputFile() {
        return this.properties.getInputFile();
    }

    public String getName() {
        return this.properties.getName();
    }

    public File getOutputFile() {
        return this.properties.getOutputFile();
    }

    public String getQueue() {
        return this.properties.getQueue();
    }

    public File getWorkingDir() {
        return this.properties.getWorkingDir();
    }

    public void setCommand(String command) {
        LocalLsfJob.check(this.status == INITIAL, "command cannot be changed after the job is submitted", this);
        this.properties.setCommand(command);
    }

    public void setErrFile(File errFile) {
        LocalLsfJob.check(this.status == INITIAL, "errFile cannot be changed after the job is submitted", this);
        this.properties.setErrFile(errFile);
    }

    public void setInputFile(File inputFile) {
        LocalLsfJob.check(this.status == INITIAL, "inputFile cannot be changed after the job is submitted", this);
        this.properties.setInputFile(inputFile);
    }

    public void setName(String name) {
        LocalLsfJob.check(this.status == INITIAL, "name cannot be changed after the job is submitted", this);
        this.properties.setName(name);
    }

    public void setOutputFile(File outputFile) {
        LocalLsfJob.check(this.status == INITIAL, "outputFile cannot be changed after the job is submitted", this);
        this.properties.setOutputFile(outputFile);
    }

    public void setProject(String project) {
        LocalLsfJob.check(this.status == INITIAL, "project cannot be changed after the job is submitted", this);
        this.properties.setProject(project);
    }

    public void setQueue(String queue) {
        LocalLsfJob.check(this.status == INITIAL, "queue cannot be changed after the job is submitted", this);
        this.properties.setQueue(queue);
    }

    public void setWorkingDir(File workingDir) {
        LocalLsfJob.check(this.status == INITIAL, "workingDir cannot be changed after the job is submitted", this);
        this.properties.setWorkingDir(workingDir);
    }

    public String getBsubJobId() {
        return this.properties.getBsubJobId();
    }

    public List<String> getExtraBsubArgs() {
        return this.properties.getExtraBsubArgs();
    }

    public void setExtraBsubArgs(List<String> extraBsubArgs) {
        this.properties.setExtraBsubArgs(extraBsubArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> readLSFOutputFile(LocalLsfJob job) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer maxSwap = null;
        Integer maxMemory = null;
        Integer cpuTime = null;
        LocalLsfJobStatus status = null;
        File outputFile = job.getOutputFile();
        FileReader fr = null;
        boolean sanityCheck1 = false;
        boolean seenResourceUsageLine = false;
        fr = new FileReader(outputFile);
        try {
            String line;
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("Your job looked like:")) {
                    sanityCheck1 = true;
                    continue;
                }
                if (line.startsWith("Exited with exit code")) {
                    LocalLsfJob.check(sanityCheck1, "Found 'Exited with exit code' line before 'Your job looked like' line.");
                    LocalLsfJob.check(status == null, "Found 'Exited with exit code' line, but status was already determined.");
                    status = LSF_EXIT;
                    continue;
                }
                if (line.startsWith("Successfully completed")) {
                    LocalLsfJob.check(sanityCheck1, "Found 'Successfully completed' line before 'Your job looked like' line.");
                    LocalLsfJob.check(status == null, "Found 'Successfully completed' line, but status was already determined.");
                    status = DONE;
                    continue;
                }
                if (line.startsWith("Exited with signal termination:")) {
                    LocalLsfJob.check(sanityCheck1, "Found 'Exited with signal termination' line before 'Your job looked like' line.");
                    LocalLsfJob.check(status == null, "Found 'Exited with signal termination' line, but status was already determined.");
                    status = LSF_SIGNALED;
                    continue;
                }
                if (line.equals("Exited")) {
                    LocalLsfJob.check(sanityCheck1, "Found 'Exited' line before 'Your job looked like' line.");
                    LocalLsfJob.check(status == null, "Found 'Exited' line, but status was already determined.");
                    status = EXITED_UNKNOWN;
                    continue;
                }
                if (line.equals("Resource usage summary:")) {
                    LocalLsfJob.check(status != null, "Found 'Resource usage summary' line, but have not yet determined job status.");
                    LocalLsfJob.check(!seenResourceUsageLine, "Found two 'Resource usage summary' lines!");
                    seenResourceUsageLine = true;
                    continue;
                }
                if (line.equals("The output (if any) follows:")) {
                    LocalLsfJob.check(status != null, "Reached job output without determining status.");
                    break;
                }
                Matcher m = cpuTimePattern.matcher(line);
                if (m.matches()) {
                    LocalLsfJob.check(seenResourceUsageLine, new Object[0]);
                    LocalLsfJob.check(cpuTime == null, new Object[0]);
                    cpuTime = new Integer(m.group(1));
                    continue;
                }
                m = maxMemoryPattern.matcher(line);
                if (m.matches()) {
                    LocalLsfJob.check(seenResourceUsageLine, new Object[0]);
                    LocalLsfJob.check(maxMemory == null, new Object[0]);
                    maxMemory = new Integer(m.group(1));
                    continue;
                }
                m = maxSwapPattern.matcher(line);
                if (!m.matches()) continue;
                LocalLsfJob.check(seenResourceUsageLine, new Object[0]);
                LocalLsfJob.check(maxSwap == null, new Object[0]);
                maxSwap = new Integer(m.group(1));
            }
        }
        finally {
            try {
                fr.close();
            }
            catch (Exception ex) {}
        }
        map.put("status", status);
        map.put("cpuTime", cpuTime);
        map.put("maxSwap", maxSwap);
        map.put("maxMemory", maxMemory);
        return map;
    }

    public static void waitUntilDone(List<LocalLsfJob> jobs) {
        LocalLsfJob.waitUntilDone(jobs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilDone(List<LocalLsfJob> jobs, String queue) {
        try {
            assert (jobs.size() > 0);
            File tempStdoutFile = File.createTempFile("LocalLsfJob.waitUntilDone", ".stdout");
            File tempStderrFile = File.createTempFile("LocalLsfJob.waitUntilDone", ".stderr");
            try {
                StringBuilder dependencyExpression = new StringBuilder("ended(" + jobs.get(0).getBsubJobId() + ")");
                for (int i = 1; i < jobs.size(); ++i) {
                    dependencyExpression.append(" && ended(" + jobs.get(i).getBsubJobId() + ")");
                }
                ArrayList<String> extraBsubArgs = new ArrayList<String>();
                extraBsubArgs.add("-w");
                extraBsubArgs.add(dependencyExpression.toString());
                extraBsubArgs.add("-K");
                LocalLsfJob job = new LocalLsfJob();
                job.setExtraBsubArgs(extraBsubArgs);
                job.setOutputFile(tempStdoutFile);
                job.setErrFile(tempStderrFile);
                job.setWorkingDir(new File("."));
                job.setCommand("echo");
                if (queue != null) {
                    job.setQueue(queue);
                }
                job.start();
                LocalLsfJobStatus status = job.updateStatus();
                if (!status.equals(DONE)) {
                    String stderrContents = FileUtil.readFile(tempStderrFile, FileUtil.FIVE_MB);
                    String stdoutContents = FileUtil.readFile(tempStdoutFile, FileUtil.FIVE_MB);
                    throw new BroadCoreException("Unexpected status: " + status + " from LSF job.  Stderr: " + stderrContents + "; Stdout: " + stdoutContents);
                }
            }
            finally {
                tempStdoutFile.delete();
                tempStderrFile.delete();
            }
        }
        catch (IOException e) {
            throw new BroadCoreException("Exception waiting for LSF jobs to finish.", e);
        }
    }

    public static LocalLsfJobStatus readStatusFromFile(LocalLsfJob job) {
        try {
            Map<String, Object> results = LocalLsfJob.readLSFOutputFile(job);
            return (LocalLsfJobStatus)results.get("status");
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getCommand() {
        return this.properties.getCommand();
    }

    public void setBsubJobId(String id) {
        this.properties.setBsubJobId(id);
    }

    public String getLsfStatusCode() {
        LocalLsfJobStatus status = this.getStatus();
        for (Map.Entry<String, LocalLsfJobStatus> entry : lsfStatusMap.entrySet()) {
            if (!((Object)entry.getValue()).equals(status)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void setLsfStatusCode(String lsfStatusCode) {
        LocalLsfJobStatus status = lsfStatusMap.get(lsfStatusCode);
        this.setStatus(status);
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    private static void check(boolean condition, Object ... stuff) {
        if (!condition) {
            throw new BroadCoreException(Arrays.toString(stuff));
        }
    }

    static {
        lsfStatusMap.put("PEND", LSF_PENDING);
        lsfStatusMap.put("PSUSP", SUSPENDED);
        lsfStatusMap.put("RUN", RUNNING);
        lsfStatusMap.put("USUSP", SUSPENDED);
        lsfStatusMap.put("SSUSP", SUSPENDED);
        lsfStatusMap.put("WAIT", LSF_WAIT);
        lsfStatusMap.put("DONE", DONE);
        lsfStatusMap.put("EXIT", LSF_EXIT);
        lsfStatusMap.put("ZOMBI", LSF_ZOMBIE);
        lsfStatusMap.put("UNKWN", LSF_UNKNOWN);
        processController = new ThreadLocal(){

            protected Object initialValue() {
                return new ProcessController();
            }
        };
    }
}

