/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports.web.chart;

import edu.mit.broad.core.customreports.CustomReport;
import edu.mit.broad.core.customreports.CustomReportManager;
import edu.mit.broad.core.customreports.HtmlTableReportRenderer;
import edu.mit.broad.core.customreports.ReportDomain;
import edu.mit.broad.core.customreports.chart.CustomReportChartDef;
import edu.mit.broad.core.customreports.chart.CustomReportChartDefManager;
import edu.mit.broad.core.customreports.chart.JFreeChartUtility;
import edu.mit.broad.core.customreports.chart.RequiredChartTypeOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

@UrlBinding(value="/Chart.action")
public class ChartActionBean
implements ActionBean {
    private static Log log = LogFactory.getLog(ChartActionBean.class);
    public static final String SHOW_ALL_CHARTS_VIEW = "ShowAllCharts";
    public static final String RETRIEVE_SUMMARY_CHART_VIEW = "RetrieveSummaryChart";
    public static final String RETRIEVE_SUMMARY_DATA_VIEW = "RetrieveSummaryData";
    public static final String SETUP_NEW_CHART_VIEW = "SetupNewChart";
    public static final String SAVE_CHART_VIEW = "SaveChart";
    public static final String EDIT_CHART_VIEW = "EditChart";
    public static final String DELETE_CHART_VIEW = "DeleteChart";
    private static final String DOMAINS_SESSION = "_custom_reports.domains";
    private static final String CHART_DEF_ID_SESSION = "_custom_reports.chartDefinitionId";
    private static final String FULL_NAME_SESSION = "_custom_reports.fullName";
    private static final String VARIABLES_SESSION = "_custom_reports.variables";
    private static final String DELETE_CHART_MESSAGE = "The selected chart has been deleted.";
    private static final String SAVE_CHART_MESSAGE = "The chart has been saved.";
    private Set<CustomReport> customReports = new TreeSet<CustomReport>();
    private List<CustomReportChartDef> allChartDefs = new ArrayList<CustomReportChartDef>();
    private String description;
    private Long fullCustomReportId;
    private Long summaryCustomReportId;
    private Long chartWidth;
    private Long chartHeight;
    private CustomReportChartDef.ChartType chartType;
    private Long chartDefinitionId;
    private String name;
    private String rangeAxisLabel;
    private String plotOrientation;
    private Boolean legend;
    private String tableOrder;
    private Integer binNumber;
    private Boolean overlayStatus;
    private ReportDomain domain;
    private CustomReportChartDef chartDef;
    private ActionBeanContext context;
    private Map<String, Object> variables;
    private String contextPath;
    private String fullName;
    private String view;
    private ReportDomain[] domains;

    @ValidationMethod(on={"SaveChart"})
    public void validate(ValidationErrors validationErrors) {
        RequiredChartTypeOptions reqs = null;
        if (this.chartType.equals((Object)CustomReportChartDef.ChartType.BAR)) {
            reqs = RequiredChartTypeOptions.BAR;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.HISTOGRAM)) {
            reqs = RequiredChartTypeOptions.HISTOGRAM;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.LINE)) {
            reqs = RequiredChartTypeOptions.LINE;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.AREA)) {
            reqs = RequiredChartTypeOptions.AREA;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.BAR_3D)) {
            reqs = RequiredChartTypeOptions.BAR_3D;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.LINE_3D)) {
            reqs = RequiredChartTypeOptions.LINE_3D;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.MULTIPLE_PIE)) {
            reqs = RequiredChartTypeOptions.MULTIPLE_PIE;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.MULTIPLE_PIE_3D)) {
            reqs = RequiredChartTypeOptions.MULTIPLE_PIE_3D;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.STACKED_AREA)) {
            reqs = RequiredChartTypeOptions.STACKED_AREA;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.STACKED_BAR)) {
            reqs = RequiredChartTypeOptions.STACKED_BAR;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.STACKED_BAR_3D)) {
            reqs = RequiredChartTypeOptions.STACKED_BAR_3D;
        } else if (this.chartType.equals((Object)CustomReportChartDef.ChartType.WATERFALL)) {
            reqs = RequiredChartTypeOptions.WATERFALL;
        }
        if (reqs.getBinNumber().booleanValue() && this.getBinNumber() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please enter a Bin Number.", new Object[0]));
        }
        if (reqs.getLegend().booleanValue() && this.getLegend() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please whether or not you want a legend.", new Object[0]));
        }
        if (reqs.getOverlayStatus().booleanValue() && this.getOverlayStatus() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select an Overlay Status.", new Object[0]));
        }
        if (reqs.getPlotOrientation().booleanValue() && this.isNullOrBlank(this.getPlotOrientation())) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select a Plot Orientation.", new Object[0]));
        }
        if (reqs.getRangeAxisLabel().booleanValue() && this.isNullOrBlank(this.getRangeAxisLabel())) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please enter a Range Axis Label.", new Object[0]));
        }
        if (reqs.getTableOrder().booleanValue() && this.isNullOrBlank(this.getTableOrder())) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select a Table Order.", new Object[0]));
        }
        if (this.isNullOrBlank(this.getName())) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please enter a Name.", new Object[0]));
        }
        if (this.getFullCustomReportId() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select a Download Report.", new Object[0]));
        }
        if (this.getSummaryCustomReportId() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select a Charted Report.", new Object[0]));
        }
        if (this.getChartWidth() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please enter a Chart Width.", new Object[0]));
        }
        if (this.getChartHeight() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please enter a Chart Height.", new Object[0]));
        }
        if (this.getChartType() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select a Chart Type.", new Object[0]));
        }
        if (this.getDomain() == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please select a Domain.", new Object[0]));
        }
        if (!this.getContext().getValidationErrors().isEmpty()) {
            CustomReportManager customReportManager = new CustomReportManager();
            this.setCustomReports(customReportManager.getReports(null, null, null, this.getCategories()));
            this.view = EDIT_CHART_VIEW;
        }
    }

    private boolean isNullOrBlank(String checkMe) {
        return checkMe == null || checkMe.trim().equals("");
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    protected void initializeData() {
        this.domains = (ReportDomain[])this.getContext().getRequest().getSession().getAttribute(DOMAINS_SESSION);
        this.fullName = (String)this.getContext().getRequest().getSession().getAttribute(FULL_NAME_SESSION);
        this.variables = (Map)this.getContext().getRequest().getSession().getAttribute(VARIABLES_SESSION);
        CustomReportChartDefManager chartMgr = new CustomReportChartDefManager();
        if (this.chartDefinitionId == null) {
            this.chartDefinitionId = (Long)this.getContext().getRequest().getSession().getAttribute(CHART_DEF_ID_SESSION);
            this.getContext().getRequest().getSession().removeAttribute(CHART_DEF_ID_SESSION);
        } else {
            this.getContext().getRequest().getSession().removeAttribute(CHART_DEF_ID_SESSION);
        }
        if (this.chartDefinitionId != null) {
            this.chartDef = chartMgr.getChart(this.chartDefinitionId);
        }
        if (this.fullName == null) {
            this.fullName = "";
        }
        if (this.view == null || this.view.equals(SHOW_ALL_CHARTS_VIEW)) {
            ArrayList<ReportDomain> domainList = new ArrayList<ReportDomain>();
            Collections.addAll(domainList, this.domains);
            this.allChartDefs.addAll(chartMgr.getChartDefsByDomainList(domainList));
        }
    }

    @DefaultHandler
    @HandlesEvent(value="ShowAllCharts")
    public Resolution showAllCharts() {
        return this.view(SHOW_ALL_CHARTS_VIEW);
    }

    @HandlesEvent(value="DeleteChart")
    public Resolution deleteChart() {
        CustomReportChartDefManager chartMgr = new CustomReportChartDefManager();
        this.allChartDefs.clear();
        chartMgr.delete(this.chartDef);
        ArrayList<ReportDomain> domainList = new ArrayList<ReportDomain>();
        Collections.addAll(domainList, this.domains);
        this.allChartDefs.addAll(chartMgr.getChartDefsByDomainList(domainList));
        this.getContext().getMessages().add(new SimpleError(DELETE_CHART_MESSAGE, new Object[0]));
        return this.showAllCharts();
    }

    @HandlesEvent(value="RetrieveSummaryChart")
    public Resolution retrieveSummaryChart() {
        JFreeChart chart = null;
        if (this.chartDef != null) {
            try {
                chart = new JFreeChartUtility().getCustomReportChartFromChartDef(this.chartDef, this.fullName, this.variables);
            }
            catch (Throwable e) {
                log.error((Object)"Error running custom report: ", e);
            }
        }
        if (chart != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)this.chartDef.getChartWidth().intValue(), (int)this.chartDef.getChartHeight().intValue());
            }
            catch (IOException e) {
                log.error((Object)("IOException writing dashboard report id: " + this.chartDef.getFullCustomReportId()));
                return new RedirectResolution("/images/dashboard_error.png");
            }
            return new StreamingResolution("img/png", (InputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        return new RedirectResolution("/images/dashboard_error.png");
    }

    @HandlesEvent(value="RetrieveSummaryData")
    public Resolution retrieveSummaryData() {
        this.view = RETRIEVE_SUMMARY_DATA_VIEW;
        return new StreamingResolution("text/html"){

            public void stream(HttpServletResponse response) throws Exception {
                CustomReportManager mgr = new CustomReportManager();
                mgr.writeResults(ChartActionBean.this.chartDef.getSummaryCustomReportId(), ChartActionBean.this.variables, new HtmlTableReportRenderer(response.getWriter()), ChartActionBean.this.getFullName());
            }
        };
    }

    @HandlesEvent(value="SetupNewChart")
    public Resolution setupNewChart() {
        CustomReportManager customReportManager = new CustomReportManager();
        this.setCustomReports(customReportManager.getReports(null, null, null, this.getCategories()));
        this.setChartDefinitionId(null);
        return this.view(SETUP_NEW_CHART_VIEW);
    }

    @HandlesEvent(value="SaveChart")
    public Resolution saveChart() {
        CustomReportChartDefManager chartManager = new CustomReportChartDefManager();
        Date date = new Date();
        if (this.chartDef == null) {
            this.chartDef = new CustomReportChartDef();
            this.chartDef.setCreatedBy(this.fullName);
            this.chartDef.setCreatedOn(date);
        }
        this.chartDef.setLastUpdatedOn(date);
        this.chartDef.setBinNumber(this.binNumber);
        this.chartDef.setChartHeight(this.chartHeight);
        this.chartDef.setChartType(this.chartType);
        this.chartDef.setChartWidth(this.chartWidth);
        this.chartDef.setDescription(this.description);
        this.chartDef.setFullCustomReportId(this.fullCustomReportId);
        this.chartDef.setLegend(this.legend);
        this.chartDef.setName(this.name);
        this.chartDef.setOverlayStatus(this.overlayStatus);
        this.chartDef.setPlotOrientation(this.plotOrientation);
        this.chartDef.setRangeAxisLabel(this.rangeAxisLabel);
        this.chartDef.setDomain(this.domain);
        this.chartDef.setSummaryCustomReportId(this.summaryCustomReportId);
        this.chartDef.setTableOrder(this.tableOrder);
        this.chartDef.setUpdatedBy(this.fullName);
        chartManager.save(this.chartDef);
        this.getContext().getMessages().add(new SimpleError(SAVE_CHART_MESSAGE, new Object[0]));
        return this.showAllCharts();
    }

    @HandlesEvent(value="EditChart")
    public Resolution editChart() {
        CustomReportManager customReportManager = new CustomReportManager();
        this.setCustomReports(customReportManager.getReports(null, null, null, this.getCategories()));
        if (this.chartDef != null) {
            this.binNumber = this.chartDef.getBinNumber();
            this.chartHeight = this.chartDef.getChartHeight();
            this.chartType = this.chartDef.getChartType();
            this.chartWidth = this.chartDef.getChartWidth();
            this.description = this.chartDef.getDescription();
            this.fullCustomReportId = this.chartDef.getFullCustomReportId();
            this.legend = this.chartDef.getLegend();
            this.name = this.chartDef.getName();
            this.overlayStatus = this.chartDef.getOverlayStatus();
            this.plotOrientation = this.chartDef.getRealPlotOrientation().toString();
            this.rangeAxisLabel = this.chartDef.getRangeAxisLabel();
            this.summaryCustomReportId = this.chartDef.getSummaryCustomReportId();
            this.tableOrder = this.chartDef.getRealTableOrder().toString();
        }
        return this.view(EDIT_CHART_VIEW);
    }

    protected Resolution view(String view) {
        this.view = view;
        return this.getContext().getSourcePageResolution();
    }

    public List<ReportDomain> getCategories() {
        ArrayList<ReportDomain> domainList = new ArrayList<ReportDomain>();
        Collections.addAll(domainList, this.domains);
        return domainList;
    }

    public List<RequiredChartTypeOptions> getRequiredChartTypeOptions() {
        ArrayList<RequiredChartTypeOptions> requirements = new ArrayList<RequiredChartTypeOptions>();
        requirements.add(RequiredChartTypeOptions.AREA);
        requirements.add(RequiredChartTypeOptions.BAR);
        requirements.add(RequiredChartTypeOptions.BAR_3D);
        requirements.add(RequiredChartTypeOptions.HISTOGRAM);
        requirements.add(RequiredChartTypeOptions.LINE);
        requirements.add(RequiredChartTypeOptions.LINE_3D);
        requirements.add(RequiredChartTypeOptions.MULTIPLE_PIE);
        requirements.add(RequiredChartTypeOptions.MULTIPLE_PIE_3D);
        requirements.add(RequiredChartTypeOptions.STACKED_AREA);
        requirements.add(RequiredChartTypeOptions.STACKED_BAR);
        requirements.add(RequiredChartTypeOptions.STACKED_BAR_3D);
        requirements.add(RequiredChartTypeOptions.WATERFALL);
        return requirements;
    }

    public int getDomainsSize() {
        return this.getDomains().length;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Set<CustomReport> getCustomReports() {
        return this.customReports;
    }

    public void setCustomReports(Set<CustomReport> customReports) {
        this.customReports = customReports;
    }

    public CustomReportChartDef getChartDef() {
        return this.chartDef;
    }

    public void setChartDef(CustomReportChartDef chartDef) {
        this.chartDef = chartDef;
    }

    public Long getChartDefinitionId() {
        return this.chartDefinitionId;
    }

    public void setChartDefinitionId(Long chartDefinitionId) {
        this.chartDefinitionId = chartDefinitionId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Boolean getLegend() {
        return this.legend;
    }

    public void setLegend(Boolean legend) {
        this.legend = legend;
    }

    public Boolean isLegend() {
        return this.legend;
    }

    public String getPlotOrientation() {
        return this.plotOrientation;
    }

    public void setPlotOrientation(String plotOrientation) {
        this.plotOrientation = plotOrientation;
    }

    public String getRangeAxisLabel() {
        return this.rangeAxisLabel;
    }

    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    public String getTableOrder() {
        return this.tableOrder;
    }

    public void setTableOrder(String tableOrder) {
        this.tableOrder = tableOrder;
    }

    public Integer getBinNumber() {
        return this.binNumber;
    }

    public void setBinNumber(Integer binNumber) {
        this.binNumber = binNumber;
    }

    public Long getChartHeight() {
        return this.chartHeight;
    }

    public void setChartHeight(Long chartHeight) {
        this.chartHeight = chartHeight;
    }

    public CustomReportChartDef.ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(CustomReportChartDef.ChartType chartType) {
        this.chartType = chartType;
    }

    public Long getChartWidth() {
        return this.chartWidth;
    }

    public void setChartWidth(Long chartWidth) {
        this.chartWidth = chartWidth;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getFullCustomReportId() {
        return this.fullCustomReportId;
    }

    public void setFullCustomReportId(Long fullCustomReportId) {
        this.fullCustomReportId = fullCustomReportId;
    }

    public Boolean getOverlayStatus() {
        return this.overlayStatus;
    }

    public void setOverlayStatus(Boolean overlayStatus) {
        this.overlayStatus = overlayStatus;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CustomReportChartDef> getAllChartDefs() {
        return this.allChartDefs;
    }

    public void setAllChartDefs(List<CustomReportChartDef> allChartDefs) {
        this.allChartDefs = allChartDefs;
    }

    public ReportDomain getDomain() {
        return this.domain;
    }

    public void setDomain(ReportDomain domain) {
        this.domain = domain;
    }

    public ReportDomain[] getDomains() {
        return this.domains;
    }

    public void setDomains(ReportDomain[] domains) {
        this.domains = domains;
    }

    public Long getSummaryCustomReportId() {
        return this.summaryCustomReportId;
    }

    public void setSummaryCustomReportId(Long summaryCustomReportId) {
        this.summaryCustomReportId = summaryCustomReportId;
    }
}

