/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports.web;

import com.thoughtworks.xstream.XStream;
import edu.mit.broad.core.Main;
import edu.mit.broad.core.common.ParameterConverter;
import edu.mit.broad.core.common.ParameterType;
import edu.mit.broad.core.customreports.CustomReport;
import edu.mit.broad.core.customreports.CustomReportCategory;
import edu.mit.broad.core.customreports.CustomReportManager;
import edu.mit.broad.core.customreports.CustomReportParameter;
import edu.mit.broad.core.customreports.CustomReportRole;
import edu.mit.broad.core.customreports.ExcelReportRenderer;
import edu.mit.broad.core.customreports.ReportDomain;
import edu.mit.broad.core.customreports.TabSeparatedReportRenderer;
import edu.mit.broad.core.customreports.web.ReportBeanCommon;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomReportActionBean
implements ReportBeanCommon,
ActionBean,
ValidationErrorHandler {
    private static final String RESOLVE_PARAMETERS = "resolveParameters";
    private static final String VIEW_REPORT = "viewReport";
    private static final String EDIT_REPORT = "editReport";
    private static final String REPORT_LIST = "reportList";
    public static final String GROUP_ID = "_custom_reports.group_id";
    public static final String PROJECT_ID = "_custom_reports.project_id";
    public static final String EXPERIMENT_ID = "_custom_reports.experiment_id";
    public static final String USER_ID = "_custom_reports.user_id";
    public static final String ROLES = "_custom_reports.roles";
    public static final String ASSIGNABLE_ROLES = "_custom_reports.assignableRoles";
    public static final String CATEGORIES = "_custom_reports.categories";
    public static final String DOMAINS = "_custom_reports.domains";
    public static final String FULL_NAME = "_custom_reports.fullName";
    private static final String CSV_FORMAT_NAME = "csv";
    private static final String XLS_FORMAT_NAME = "xls";
    private static final Log log = LogFactory.getLog(CustomReportActionBean.class);
    private final CustomReportManager mgr = new CustomReportManager();
    private ActionBeanContext context;
    private String view;
    private CustomReport report;
    private Map<String, String> variables = new HashMap<String, String>();
    private Map<String, Object> typedVariables = new HashMap<String, Object>();
    private RowSetDynaClass results;
    private Set<Long> deleteParameterIds = new HashSet<Long>();
    private String directDownloadFormat;
    private boolean groupOnly;
    private boolean projectOnly;
    private boolean experimentOnly;
    private String overrideFilename;
    private FileBean importedReport;
    public String categoryList;
    public String roleList;
    public List<String> selectedRoleList;

    public String getView() {
        return this.view;
    }

    public String getCategoryList() {
        return this.categoryList;
    }

    public void setCategoryList(String categoryList) {
        this.categoryList = categoryList;
    }

    public String getRoleList() {
        return this.roleList;
    }

    public void setRoleList(String roleList) {
        this.roleList = roleList;
    }

    public List<String> getSelectedRoleList() {
        return this.selectedRoleList;
    }

    public void setSelectedRoleList(List<String> selectedRoleList) {
        this.selectedRoleList = selectedRoleList;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public RowSetDynaClass getResults() {
        return this.results;
    }

    public void setResults(RowSetDynaClass results) {
        this.results = results;
    }

    public CustomReport getReport() {
        return this.report;
    }

    public void setReport(CustomReport report) {
        this.report = report;
    }

    public Set<Long> getDeleteParameterIds() {
        return this.deleteParameterIds;
    }

    public void setDeleteParameterIds(Set<Long> deleteParameterIds) {
        this.deleteParameterIds = deleteParameterIds;
    }

    public String getDirectDownloadFormat() {
        return this.directDownloadFormat;
    }

    public void setDirectDownloadFormat(String directDownloadFormat) {
        this.directDownloadFormat = directDownloadFormat;
    }

    public boolean isGroupOnly() {
        return this.groupOnly;
    }

    public void setGroupOnly(boolean groupOnly) {
        this.groupOnly = groupOnly;
    }

    public boolean isProjectOnly() {
        return this.projectOnly;
    }

    public void setProjectOnly(boolean projectOnly) {
        this.projectOnly = projectOnly;
    }

    public boolean isExperimentOnly() {
        return this.experimentOnly;
    }

    public void setExperimentOnly(boolean experimentOnly) {
        this.experimentOnly = experimentOnly;
    }

    public FileBean getImportedReport() {
        return this.importedReport;
    }

    public void setImportedReport(FileBean importedReport) {
        this.importedReport = importedReport;
    }

    public String getOverrideFilename() {
        return this.overrideFilename;
    }

    public void setOverrideFilename(String overrideFilename) {
        this.overrideFilename = overrideFilename;
    }

    @Override
    public Boolean getEditingAllowed() {
        return true;
    }

    @Override
    public Long getGroupId() {
        return (Long)this.getContext().getRequest().getSession().getAttribute(GROUP_ID);
    }

    public long getDomainsSize() {
        return this.getDomains().size();
    }

    protected Long getProjectId() {
        return (Long)this.getContext().getRequest().getSession().getAttribute(PROJECT_ID);
    }

    @Override
    public Long getExperimentId() {
        return (Long)this.getContext().getRequest().getSession().getAttribute(EXPERIMENT_ID);
    }

    @Override
    public Long getUserId() {
        return (Long)this.getContext().getRequest().getSession().getAttribute(USER_ID);
    }

    public List<ReportDomain> getDomains() {
        return Arrays.asList((ReportDomain[])this.getContext().getRequest().getSession().getAttribute(DOMAINS));
    }

    public List<String> getUnavailableRoleList() {
        ArrayList<String> unavailableRoleList = new ArrayList<String>();
        for (CustomReportRole reportRole : this.getReport().getRoles()) {
            if (this.getAssignableRoles().contains(reportRole.getRoleName())) continue;
            unavailableRoleList.add(reportRole.getRoleName());
        }
        return unavailableRoleList;
    }

    @Override
    public List<String> getRoles() {
        List roles = (List)this.getContext().getRequest().getSession().getAttribute(ROLES);
        if (roles == null) {
            return new ArrayList<String>();
        }
        return roles;
    }

    @Override
    public List<String> getAssignableRoles() {
        List assignableRoles = (List)this.getContext().getRequest().getSession().getAttribute(ASSIGNABLE_ROLES);
        if (assignableRoles == null) {
            return new ArrayList<String>();
        }
        return assignableRoles;
    }

    public boolean usingRoleSelectList() {
        return this.getContext().getRequest().getSession().getAttribute(ASSIGNABLE_ROLES) != null;
    }

    public List<String> getCategories() {
        return (List)this.getContext().getRequest().getSession().getAttribute(CATEGORIES);
    }

    @Override
    public String getFullName() {
        return (String)this.getContext().getRequest().getSession().getAttribute(FULL_NAME);
    }

    public Collection<CustomReport> getReports() {
        return this.mgr.getReports(this.getGroupId(), this.getProjectId(), this.getExperimentId(), this.getDomains(), this.getRoles(), this.getCategories());
    }

    public List<String> getDataSources() {
        return this.mgr.getDataSourceList();
    }

    @ValidationMethod(on={"executeReport"})
    public void validate(ValidationErrors validationErrors) {
        try {
            this.setReport(this.mgr.getReportById(this.getReport().getReportId()));
            this.typedVariables.clear();
            HashMap<String, String[]> v2 = new HashMap<String, String[]>();
            for (Map.Entry<String, String> entry : this.variables.entrySet()) {
                v2.put(entry.getKey(), new String[]{entry.getValue()});
            }
            ParameterConverter converter = new ParameterConverter(){

                @Override
                protected void addError(ParameterType param, String value, ValidationErrors errors, ValidationError error) {
                    error.setFieldValue(value);
                    errors.add("variables['" + param.getName() + "']", error);
                    error.setFieldName(param.getDescription());
                }
            };
            converter.convertParameters(v2, this.typedVariables, this.report.getParameters(), this.getContext().getLocale(), this.getContext().getValidationErrors());
        }
        catch (Throwable e) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed variable type conversion: " + e.getMessage(), new Object[0]));
        }
    }

    public Resolution handleValidationErrors(ValidationErrors errors) throws Exception {
        this.view = this.getContext().getEventName().equals(EDIT_REPORT) ? EDIT_REPORT : RESOLVE_PARAMETERS;
        return null;
    }

    public Resolution resolveParameters() throws Exception {
        if (this.getReport() != null) {
            this.setReport(this.mgr.getReportById(this.getReport().getReportId()));
            if (this.getReport().getParameters().size() > 0) {
                return this.view(RESOLVE_PARAMETERS);
            }
            return this.executeReport();
        }
        this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Please Select a Report", new Object[0]));
        return this.getContext().getSourcePageResolution();
    }

    @DontValidate
    public Resolution exportReport() throws Exception {
        this.report = this.mgr.getFullReportById(this.getReport().getReportId());
        this.view = "none";
        return new StreamingResolution("text/xml"){

            public void stream(HttpServletResponse response) throws Exception {
                new XStream().toXML((Object)CustomReportActionBean.this.report, (Writer)response.getWriter());
            }
        }.setFilename(this.getReport().getName().replace(" ", "_") + ".xml");
    }

    @DontValidate
    public Resolution importReport() throws Exception {
        XStream xstream = new XStream();
        if (this.importedReport == null) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed to import report: No report file was provided.", new Object[0]));
            return this.view(REPORT_LIST);
        }
        try {
            this.report = (CustomReport)xstream.fromXML(this.importedReport.getInputStream());
        }
        catch (Exception ex) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed to import report: An exception occurred: " + ex.getMessage(), new Object[0]));
            return this.view(REPORT_LIST);
        }
        this.report.setReportId(0L);
        this.groupOnly = this.report.getGroupId() != null;
        this.projectOnly = this.report.getProjectId() != null;
        this.experimentOnly = this.report.getExperimentId() != null;
        this.categoryList = this.report.getCategoryList();
        this.roleList = this.report.getRoleList();
        this.selectedRoleList = new ArrayList<String>();
        for (String role : this.roleList.split(",")) {
            this.selectedRoleList.add(role.trim());
        }
        return this.view(EDIT_REPORT);
    }

    public Resolution executeReport() throws Exception {
        this.addImplicitTypedVariables();
        if (this.directDownloadFormat != null && this.directDownloadFormat.length() > 0) {
            this.view = "none";
            String baseFileName = this.getReport().getName().replace(" ", "_");
            if (this.overrideFilename != null && this.overrideFilename.length() > 0) {
                baseFileName = this.overrideFilename;
            }
            if (this.directDownloadFormat.equalsIgnoreCase(CSV_FORMAT_NAME)) {
                return new StreamingResolution("text/plain"){

                    public void stream(HttpServletResponse response) throws Exception {
                        CustomReportActionBean.this.mgr.writeResults(CustomReportActionBean.this.report.getReportId(), CustomReportActionBean.this.typedVariables, new TabSeparatedReportRenderer((OutputStream)response.getOutputStream()), CustomReportActionBean.this.getFullName());
                    }
                }.setFilename(baseFileName + ".txt");
            }
            if (this.directDownloadFormat.equalsIgnoreCase(XLS_FORMAT_NAME)) {
                return new StreamingResolution("text/plain"){

                    public void stream(HttpServletResponse response) throws Exception {
                        CustomReportActionBean.this.mgr.writeResults(CustomReportActionBean.this.report.getReportId(), CustomReportActionBean.this.typedVariables, new ExcelReportRenderer((OutputStream)response.getOutputStream()), CustomReportActionBean.this.getFullName());
                    }
                }.setFilename(baseFileName + ".xls");
            }
        }
        try {
            this.results = this.mgr.executeReport(this.report.getReportId(), this.typedVariables, this.getFullName());
        }
        catch (Throwable e) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed preparing report: " + e.getMessage(), new Object[0]));
            return this.view(REPORT_LIST);
        }
        return this.view(VIEW_REPORT);
    }

    protected void addImplicitTypedVariables() {
        this.typedVariables.put("env", Main.getInstance().getEnvironment());
        this.typedVariables.put("groupId", this.getGroupId());
        this.typedVariables.put("projectId", this.getProjectId());
        this.typedVariables.put("experimentId", this.getExperimentId());
        this.typedVariables.put("userId", this.getUserId());
    }

    @DontValidate
    public Resolution createReport() throws Exception {
        this.setReport(null);
        return this.view(EDIT_REPORT);
    }

    @DontValidate
    public Resolution editReport() throws Exception {
        try {
            this.report = this.mgr.getReportById(this.getReport().getReportId());
            this.groupOnly = this.report.getGroupId() != null;
            this.projectOnly = this.report.getProjectId() != null;
            this.experimentOnly = this.report.getExperimentId() != null;
            this.categoryList = this.report.getCategoryList();
            this.roleList = this.report.getRoleList();
            this.selectedRoleList = new ArrayList<String>();
            for (String role : this.roleList.split(",")) {
                this.selectedRoleList.add(role.trim());
            }
            return this.view(EDIT_REPORT);
        }
        catch (Throwable e) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed displaying edit page: Please select a report for editing: <br/>" + e.getMessage(), new Object[0]));
            return this.view(REPORT_LIST);
        }
    }

    @DontValidate
    public Resolution deleteReport() throws Exception {
        try {
            this.report = this.mgr.getReportById(this.getReport().getReportId());
            this.mgr.delete(this.report);
            return this.view(REPORT_LIST);
        }
        catch (Throwable e) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed displaying edit page: Please select a report for editing: <br/>" + e.getMessage(), new Object[0]));
            return this.view(REPORT_LIST);
        }
    }

    private CustomReport cloneReport(CustomReport report) {
        CustomReport newReport = new CustomReport();
        Date date = new Date();
        newReport.setName(report.getName() + " [Copied On: " + date.toString() + "]");
        newReport.setCreatedBy(this.getFullName());
        newReport.setCreatedDate(date);
        TreeSet<String> categoryNames = new TreeSet<String>();
        for (CustomReportCategory category : report.getCategories()) {
            categoryNames.add(category.getName());
        }
        TreeSet<String> roleNames = new TreeSet<String>();
        for (CustomReportRole role : report.getRoles()) {
            roleNames.add(role.getRoleName());
        }
        newReport.setData(report.getData());
        newReport.setDescription(report.getDescription());
        newReport.setDomain(report.getDomain());
        newReport.setExperimentId(report.getExperimentId());
        newReport.setGroupId(report.getGroupId());
        newReport.setProjectId(report.getProjectId());
        newReport.setReportType(report.getReportType());
        ArrayList<CustomReportParameter> parameters = new ArrayList<CustomReportParameter>();
        for (CustomReportParameter parameter : report.getParameters()) {
            CustomReportParameter newParameter = new CustomReportParameter();
            newParameter.setIdx(parameter.getIdx());
            newParameter.setName(parameter.getName());
            newParameter.setPrompt(parameter.getPrompt());
            newParameter.setReport(newReport);
            newParameter.setTypeClass(parameter.getTypeClass());
            parameters.add(newParameter);
        }
        newReport.setParameters(parameters);
        this.mgr.save(newReport);
        this.mgr.setCategories(newReport.getReportId(), categoryNames);
        this.mgr.setRoles(newReport.getReportId(), roleNames);
        this.mgr.save(newReport);
        return newReport;
    }

    @DontValidate
    public Resolution copyReport() throws Exception {
        try {
            this.report = this.mgr.getFullReportById(this.report.getReportId());
            this.report = this.cloneReport(this.report);
            return this.view(REPORT_LIST);
        }
        catch (Throwable e) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed to clone report: An exception occurred: " + e.getMessage(), new Object[0]));
            return this.view(REPORT_LIST);
        }
    }

    private void removeNullParameters() {
        Iterator<CustomReportParameter> iter = this.getReport().getParameters().iterator();
        while (iter.hasNext()) {
            CustomReportParameter param = iter.next();
            if (param != null) continue;
            iter.remove();
        }
    }

    @DontValidate
    public Resolution saveReport() throws Exception {
        SortedSet<String> updatedRoleList;
        this.removeNullParameters();
        Iterator<CustomReportParameter> iter = this.getReport().getParameters().iterator();
        while (iter.hasNext()) {
            CustomReportParameter param = iter.next();
            if (!this.deleteParameterIds.contains(param.getParameterId())) continue;
            iter.remove();
            this.mgr.deleteParameter(param);
        }
        for (int i = 0; i < this.getReport().getParameters().size(); ++i) {
            CustomReportParameter param = this.getReport().getParameters().get(i);
            param.setReport(this.getReport());
            param.setIdx(Long.valueOf(i));
        }
        if (this.experimentOnly) {
            this.getReport().setExperimentId(this.getExperimentId());
        }
        if (this.projectOnly || this.experimentOnly) {
            this.getReport().setProjectId(this.getProjectId());
        }
        if (this.groupOnly || this.projectOnly || this.experimentOnly) {
            this.getReport().setGroupId(this.getGroupId());
        }
        if (this.getReport().getReportId() < 1L) {
            this.getReport().setCreatedBy(this.getFullName());
            this.getReport().setCreatedDate(new Date());
        }
        try {
            this.mgr.checkParamType(this.getReport());
            this.setReport(this.mgr.merge(this.getReport()));
        }
        catch (Throwable e) {
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("Failed saving custom report: " + e.getMessage(), new Object[0]));
            return this.view(EDIT_REPORT);
        }
        SortedSet<String> updatedCategoryList = this.getUpdatedCategoryList();
        if (updatedCategoryList != null) {
            this.setReport(this.mgr.setCategories(this.getReport().getReportId(), updatedCategoryList));
            this.setReport(this.mgr.merge(this.getReport()));
        }
        if ((updatedRoleList = this.getUpdatedRoleList()) != null) {
            this.setReport(this.mgr.setRoles(this.getReport().getReportId(), updatedRoleList));
            this.setReport(this.mgr.merge(this.getReport()));
        }
        return this.view(REPORT_LIST);
    }

    private SortedSet<String> getUpdatedCategoryList() {
        SortedSet<CustomReportCategory> currentCategories;
        TreeSet<String> categoryNames = new TreeSet<String>();
        if (this.getCategoryList() != null) {
            for (String categoryString : this.getCategoryList().split(",")) {
                categoryNames.add(categoryString.trim());
            }
        }
        if (this.isSame(currentCategories = this.getReport().getCategories(), categoryNames)) {
            return null;
        }
        return categoryNames;
    }

    private SortedSet<String> getUpdatedRoleList() {
        SortedSet<CustomReportRole> currentRoles;
        TreeSet<String> roleNames = new TreeSet<String>();
        if (this.usingRoleSelectList()) {
            if (this.getSelectedRoleList() != null && !this.getSelectedRoleList().isEmpty()) {
                roleNames.addAll(this.getSelectedRoleList());
            }
        } else if (!this.getRoleList().isEmpty()) {
            for (String roleString : this.getRoleList().split(",")) {
                roleNames.add(roleString.trim());
            }
        }
        if (this.isRolesSame(currentRoles = this.getReport().getRoles(), roleNames)) {
            return null;
        }
        return roleNames;
    }

    private boolean isSame(SortedSet<CustomReportCategory> currentCategories, SortedSet<String> categoryNames) {
        if (currentCategories == null) {
            return false;
        }
        if (currentCategories.size() != categoryNames.size()) {
            return false;
        }
        Iterator currentIterator = currentCategories.iterator();
        for (String categoryName : categoryNames) {
            if (categoryName.equals(((CustomReportCategory)currentIterator.next()).getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isRolesSame(SortedSet<CustomReportRole> currentRoles, SortedSet<String> roleNames) {
        if (currentRoles == null) {
            return false;
        }
        if (currentRoles.size() != roleNames.size()) {
            return false;
        }
        Iterator currentIterator = currentRoles.iterator();
        for (String roleName : roleNames) {
            if (roleName.equals(((CustomReportRole)currentIterator.next()).getRoleName())) continue;
            return false;
        }
        return true;
    }

    @DontValidate
    public Resolution validateReport() throws Exception {
        this.addImplicitTypedVariables();
        try {
            this.mgr.validateCustomReport(this.getReport(), this.typedVariables);
        }
        catch (Throwable e) {
            log.info((Object)"Exception validating custom report.", e);
            this.getContext().getValidationErrors().addGlobalError((ValidationError)new SimpleError("CustomReport Validation failed: " + e.getMessage(), new Object[0]));
        }
        return this.view(EDIT_REPORT);
    }

    protected Resolution view(String view) {
        this.view = view;
        return this.getContext().getSourcePageResolution();
    }
}

