/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports.chart;

import edu.mit.broad.core.customreports.CustomReport;
import edu.mit.broad.core.customreports.CustomReportManager;
import edu.mit.broad.core.customreports.chart.CustomReportChartDef;
import edu.mit.broad.core.customreports.chart.HistogramSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.TableOrder;

public class JFreeChartUtility {
    protected static Log log = LogFactory.getLog(JFreeChartUtility.class);

    public JFreeChart getCustomReportChartFromChartDef(CustomReportChartDef chartDefinition, String fullName, Map<String, Object> parameters) {
        CustomReport report = null;
        JFreeChart chart = null;
        CustomReportManager customReportManager = new CustomReportManager();
        try {
            report = customReportManager.getReportById(chartDefinition.getSummaryCustomReportId());
        }
        catch (Exception e) {
            log.error((Object)("Error executing a dashboard report [" + chartDefinition.getName() + "]: " + e.getMessage()));
        }
        if (report != null) {
            RowSetDynaClass rowSet = customReportManager.executeReport(chartDefinition.getSummaryCustomReportId(), parameters, fullName);
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.HISTOGRAM) {
                if (chartDefinition.getOverlayStatus().booleanValue()) {
                    return this.makeOverlaidHistogram(rowSet, report.getName(), chartDefinition.getBinNumber(), chartDefinition.getRangeAxisLabel(), chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
                }
                return this.makeTiledHistogram(rowSet, report.getName(), chartDefinition.getBinNumber(), chartDefinition.getLegend());
            }
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ArrayList<DynaProperty> columns = new ArrayList<DynaProperty>();
            columns.addAll(Arrays.asList(rowSet.getDynaProperties()));
            String domainAxisLabel = ((DynaProperty)columns.get(0)).getName();
            columns.remove(0);
            for (DynaBean row : rowSet.getRows()) {
                for (DynaProperty column : columns) {
                    String columnName = WordUtils.capitalizeFully((String)column.getName().replace('_', ' '));
                    Number value = (Number)row.get(column.getName());
                    dataset.addValue(value, (Comparable)((Object)columnName), (Comparable)((Object)row.get(domainAxisLabel).toString()));
                }
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.BAR) {
                return this.makeBarChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.LINE) {
                return this.makeLineChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.AREA) {
                return this.makeAreaChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.BAR_3D) {
                return this.makeBar3DChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.LINE_3D) {
                return this.makeLine3DChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.MULTIPLE_PIE) {
                return this.makeMultiplePieChart(chartDefinition.getName(), dataset, chartDefinition.getLegend(), chartDefinition.getRealTableOrder());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.MULTIPLE_PIE_3D) {
                return this.makeMultiplePie3DChart(chartDefinition.getName(), dataset, chartDefinition.getLegend(), chartDefinition.getRealTableOrder());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.STACKED_AREA) {
                return this.makeStackedAreaChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.STACKED_BAR) {
                return this.makeStackedBarChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.STACKED_BAR_3D) {
                return this.makeStackedBar3DChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
            if (chartDefinition.getChartType() == CustomReportChartDef.ChartType.WATERFALL) {
                return this.makeWaterfallChart(chartDefinition.getName(), domainAxisLabel, chartDefinition.getRangeAxisLabel(), dataset, chartDefinition.getRealPlotOrientation(), chartDefinition.getLegend());
            }
        }
        return chart;
    }

    protected JFreeChart makeWaterfallChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createWaterfallChart((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeStackedBar3DChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeStackedBarChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeStackedAreaChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeMultiplePie3DChart(String chartName, DefaultCategoryDataset dataset, boolean legend, TableOrder tableOrder) {
        JFreeChart chart = ChartFactory.createMultiplePieChart3D((String)chartName, (CategoryDataset)dataset, (TableOrder)tableOrder, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeMultiplePieChart(String chartName, DefaultCategoryDataset dataset, boolean legend, TableOrder tableOrder) {
        JFreeChart chart = ChartFactory.createMultiplePieChart((String)chartName, (CategoryDataset)dataset, (TableOrder)tableOrder, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeLine3DChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createLineChart3D((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeBar3DChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeAreaChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createAreaChart((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        return chart;
    }

    protected JFreeChart makeBarChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        JFreeChart chart = ChartFactory.createBarChart((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setMaximumCategoryLabelWidthRatio(0.4f);
        return chart;
    }

    protected JFreeChart makeLineChart(String chartName, String domainAxisLabel, String rangeAxisLabel, DefaultCategoryDataset dataset, PlotOrientation plotOrientation, boolean legend) {
        return ChartFactory.createLineChart((String)chartName, (String)domainAxisLabel, (String)rangeAxisLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
    }

    protected JFreeChart makeOverlaidHistogram(RowSetDynaClass rowSet, String chartName, Integer binNumber, String rangeAxisLabel, PlotOrientation plotOrientation, boolean legend) {
        ArrayList<DynaProperty> columns = new ArrayList<DynaProperty>();
        columns.addAll(Arrays.asList(rowSet.getDynaProperties()));
        HashSet<HistogramSeries> histogramSeries = new HashSet<HistogramSeries>();
        for (DynaBean row : rowSet.getRows()) {
            DynaProperty firstColumn = (DynaProperty)columns.get(0);
            String seriesName = row.get(firstColumn.getName()).toString();
            for (int i = 1; i < columns.size(); ++i) {
                DynaProperty column = (DynaProperty)columns.get(i);
                String domainLabel = WordUtils.capitalizeFully((String)column.getName().replace('_', ' '));
                Double value = ((Number)row.get(column.getName())).doubleValue();
                HistogramSeries series = new HistogramSeries(binNumber, seriesName, value, domainLabel);
                if (histogramSeries.contains(series)) {
                    for (HistogramSeries hSeries : histogramSeries) {
                        if (!hSeries.equals(series)) continue;
                        hSeries.addValue(value);
                    }
                    continue;
                }
                histogramSeries.add(series);
            }
        }
        String domainLabel = null;
        HistogramDataset dataset = new HistogramDataset();
        for (HistogramSeries series : histogramSeries) {
            domainLabel = series.getDomainLabel();
            double[] valuesArray = new double[series.getValues().size()];
            for (int i = 0; i < series.getValues().size(); ++i) {
                valuesArray[i] = series.getValues().get(i);
            }
            dataset.addSeries((Comparable)((Object)(series.getSeriesName() + " - " + domainLabel)), valuesArray, series.getBinNumber().intValue());
        }
        JFreeChart chart = ChartFactory.createHistogram((String)chartName, (String)domainLabel, (String)rangeAxisLabel, (IntervalXYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)false, (boolean)false);
        if (dataset.getSeriesCount() > 1) {
            XYPlot plot = (XYPlot)chart.getPlot();
            if (dataset.getSeriesCount() == 2) {
                plot.setForegroundAlpha(0.5f);
            } else {
                plot.setBackgroundAlpha(0.3f);
                plot.setForegroundAlpha(0.3f);
            }
        }
        return chart;
    }

    protected JFreeChart makeTiledHistogram(RowSetDynaClass rowSet, String chartName, Integer binNumber, boolean legend) {
        ArrayList<DynaProperty> columns = new ArrayList<DynaProperty>();
        columns.addAll(Arrays.asList(rowSet.getDynaProperties()));
        HashSet<HistogramSeries> histogramSeries = new HashSet<HistogramSeries>();
        for (DynaBean row : rowSet.getRows()) {
            DynaProperty firstColumn = (DynaProperty)columns.get(0);
            String seriesName = row.get(firstColumn.getName()).toString();
            for (int i = 1; i < columns.size(); ++i) {
                DynaProperty column = (DynaProperty)columns.get(i);
                String xAxisLabel = WordUtils.capitalizeFully((String)column.getName().replace('_', ' '));
                Double value = ((Number)row.get(column.getName())).doubleValue();
                HistogramSeries series = new HistogramSeries(binNumber, seriesName, value, xAxisLabel);
                if (histogramSeries.contains(series)) {
                    for (HistogramSeries hSeries : histogramSeries) {
                        if (!hSeries.equals(series)) continue;
                        hSeries.addValue(value);
                    }
                    continue;
                }
                histogramSeries.add(series);
            }
        }
        ArrayList<XYPlot> plots = new ArrayList<XYPlot>();
        NumberAxis sharedAxis = new NumberAxis("Frequency");
        CombinedRangeXYPlot plot = new CombinedRangeXYPlot((ValueAxis)sharedAxis);
        for (HistogramSeries series : histogramSeries) {
            HistogramDataset dataset = new HistogramDataset();
            double[] valuesArray = new double[series.getValues().size()];
            for (int i = 0; i < series.getValues().size(); ++i) {
                valuesArray[i] = series.getValues().get(i);
            }
            Double padding = 1.0;
            try {
                padding = (double)series.getBinNumber().intValue() / series.getRange() * 0.25;
            }
            catch (ArithmeticException e) {
                log.error((Object)("ArithmeticException generating a padding for a tiled histogram, e: " + e));
            }
            dataset.addSeries((Comparable)((Object)(series.getSeriesName() + " - " + series.getDomainLabel())), valuesArray, series.getBinNumber().intValue());
            XYBarRenderer renderer = new XYBarRenderer(0.2);
            NumberAxis xAxis = new NumberAxis(series.getDomainLabel());
            xAxis.setRange(new Range(series.getMinValue() - padding, series.getMaxValue() + padding));
            XYPlot subplot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, null, (XYItemRenderer)renderer);
            plots.add(subplot);
        }
        for (XYPlot subplot : plots) {
            plot.add(subplot);
        }
        return new JFreeChart(chartName, null, (Plot)plot, legend);
    }
}

