/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.core.customreports.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HistogramSeries {
    private static Log log = LogFactory.getLog(HistogramSeries.class);
    private String seriesName;
    private List<Double> values;
    private String domainLabel;
    private Integer binNumber;

    public HistogramSeries(Integer binNumber, String seriesName, Double value, String domainLabel) {
        this.setBinNumber(binNumber);
        this.setSeriesName(seriesName);
        this.getValues().add(value);
        this.setDomainLabel(domainLabel);
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public void addValue(Double value) {
        this.getValues().add(value);
    }

    public List<Double> getValues() {
        if (this.values == null) {
            this.setValues(new ArrayList<Double>());
        }
        Collections.sort(this.values);
        return this.values;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }

    public String getDomainLabel() {
        return this.domainLabel;
    }

    public void setDomainLabel(String domainLabel) {
        this.domainLabel = domainLabel;
    }

    public Integer getBinNumber() {
        if (this.binNumber == null) {
            Double num = 1.0;
            try {
                num = Math.ceil(this.getRange() / (double)this.getBinSize().intValue());
            }
            catch (Exception e) {
                log.error((Object)("Exception setting binNumber, e: " + e));
            }
            this.setBinNumber(num.intValue());
        } else if (this.binNumber > this.getValues().size() || this.binNumber < 1) {
            this.setBinNumber(1);
        }
        return this.binNumber;
    }

    public void setBinNumber(Integer binNumber) {
        this.binNumber = binNumber;
    }

    public Double getMinValue() {
        return this.getValues().get(0);
    }

    public Double getMaxValue() {
        return this.getValues().get(this.getValues().size() - 1);
    }

    public Double getRange() {
        return this.getMaxValue() - this.getMinValue();
    }

    private Integer getBinSize() {
        Collections.sort(this.getValues());
        if (this.getMaxValue().equals(this.getMinValue())) {
            return 0;
        }
        Double delta = this.getRange();
        Double binSize = Math.ceil(delta / (double)this.getValues().size());
        return binSize.intValue();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HistogramSeries)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HistogramSeries rhs = (HistogramSeries)obj;
        return new EqualsBuilder().append((Object)this.getSeriesName(), (Object)rhs.getSeriesName()).append((Object)this.getDomainLabel(), (Object)rhs.getDomainLabel()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getSeriesName()).append((Object)this.getDomainLabel()).toHashCode();
    }
}

